﻿Public Class Util
  ''' <summary>
  ''' Return a transform that changes a x,y,z 
  ''' coordinate system to a new x',y',z' system
  ''' </summary>
  Public Shared Function TransformByVectors( _
    ByVal oldX As XYZ, _
    ByVal oldY As XYZ, _
    ByVal oldZ As XYZ, _
    ByVal oldOrigin As XYZ, _
    ByVal newX As XYZ, _
    ByVal newY As XYZ, _
    ByVal newZ As XYZ, _
    ByVal newOrigin As XYZ) As Transform

    ' [new vector] = [transform]*[old vector]
    ' [3x1] = [3x4] * [4x1]
    '
    ' [v'x]   [ i*i'  j*i'  k*i'  translationX' ]   [vx]
    ' [v'y] = [ i*j'  j*j'  k*j'  translationY' ] * [vy]
    ' [v'z]   [ i*k'  j*k'  k*k'  translationZ' ]   [vz]
    '                                               [1 ]
    Dim t As Transform = Transform.Identity

    Dim xx As Double = oldX.DotProduct(newX)
    Dim xy As Double = oldX.DotProduct(newY)
    Dim xz As Double = oldX.DotProduct(newZ)

    Dim yx As Double = oldY.DotProduct(newX)
    Dim yy As Double = oldY.DotProduct(newY)
    Dim yz As Double = oldY.DotProduct(newZ)

    Dim zx As Double = oldZ.DotProduct(newX)
    Dim zy As Double = oldZ.DotProduct(newY)
    Dim zz As Double = oldZ.DotProduct(newZ)

    t.BasisX = New XYZ(xx, xy, xz)
    t.BasisY = New XYZ(yx, yy, yz)
    t.BasisZ = New XYZ(zx, zy, zz)

    ' The movement of the origin point 
    ' in the old coordinate system

    Dim translation As XYZ = newOrigin - oldOrigin

    ' Convert the translation into coordinates 
    ' in the new coordinate system

    Dim translationNewX As Double _
      = xx * translation.X _
        + yx * translation.Y _
        + zx * translation.Z

    Dim translationNewY As Double _
      = xy * translation.X _
        + yy * translation.Y _
        + zy * translation.Z

    Dim translationNewZ As Double _
      = xz * translation.X _
        + yz * translation.Y _
        + zz * translation.Z

    t.Origin = New XYZ( _
      -translationNewX, _
      -translationNewY, _
      -translationNewZ)

    Return t

  End Function

  Public Shared Function PlanarFaceTransform( _
    ByVal face As PlanarFace) As Transform

    Return Util.TransformByVectors( _
      XYZ.BasisX, _
      XYZ.BasisY, _
      XYZ.BasisZ, _
      XYZ.Zero, _
      face.Vector(0), _
      face.Vector(1), _
      face.Normal, _
      face.Origin)
  End Function
End Class
