﻿#region Namespace
using System;

using Autodesk.AutoCAD.Runtime;
using Autodesk.AutoCAD.ApplicationServices;
using Autodesk.AutoCAD.DatabaseServices;
using Autodesk.AutoCAD.EditorInput;

//using Autodesk.Aec.DatabaseServices;
using Autodesk.Aec.Arch.DatabaseServices;
using Autodesk.Aec.Arch.Geometry;

//using ObjectIdCollection = Autodesk.AutoCAD.DatabaseServices.ObjectIdCollection;
using ObjectId = Autodesk.AutoCAD.DatabaseServices.ObjectId;
//using Graph = Autodesk.Aec.Arch.DatabaseServices.WallSystem.Graph;
//using Section = Autodesk.Aec.Arch.DatabaseServices.WallSystem.Section;
using TransactionManager = Autodesk.AutoCAD.DatabaseServices.TransactionManager;
//using DBObject = Autodesk.AutoCAD.DatabaseServices.DBObject;
#endregion

namespace PlumbCut
{
  public class PlumbCutApp : IExtensionApplication
  {
    #region IExtensionApplication Implementations
    public void Initialize()
    {
      Editor ed = Application.DocumentManager.MdiActiveDocument.Editor;
      ed.WriteMessage("Loading PlumbCut sample...\r\n");
      ed.WriteMessage("Type \"PlumbCut\" to run the sample.\r\n");
    }

    public void Terminate()
    {
    }
    #endregion

    [CommandMethod( "PlumbCut" )]
    public void PlumbCut()
    {
      Document doc = Application.DocumentManager.MdiActiveDocument;
      Editor ed = doc.Editor;
      Database db = doc.Database;
      TransactionManager tm = db.TransactionManager;
      using( Transaction t = tm.StartTransaction() )
      {
        PromptEntityOptions entopts = new PromptEntityOptions( "Select a roof slab" );
        entopts.SetRejectMessage( "Must select a roof slab, please!" );
        entopts.AddAllowedClass( typeof( RoofSlab ), false );
        PromptEntityResult ent = null;
        try
        {
          ent = ed.GetEntity( entopts );
        }
        catch
        {
          ed.WriteMessage( "You did not select a valid entity" );
          return;
        }

        if( ent.Status == PromptStatus.OK )
        {
          ObjectId entId = ent.ObjectId;

          RoofSlab roofSlab = t.GetObject( 
            entId, OpenMode.ForWrite ) as RoofSlab;

          SlabFace face = roofSlab.Face;

          foreach( SlabLoop loop in face.Loops )
          {
            foreach( SlabEdge edge in loop.Edges )
            {
              bool isPlumb = edge.IsPlumbCut;

              // SlabEdge.IsPlumbCut cannot be assigned 
              // to -- it is read only:
              //edge.IsPlumbCut = !edge.IsPlumbCut; 

              edge.SetCutOption( isPlumb );
            }
          }
        }
        t.Commit();
      }
    }
  }
}
