//
// (C) Copyright 2003-2009 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Revit.SDK.Samples.RDBLink.CS
{
    /// <summary>
    /// This is the progress form during exporting and importing
    /// </summary>
    public partial class ProgressForm : Form
    {
        #region Properties
        /// <summary>
        /// Set the maximum value for progress bar
        /// </summary>
        public int ProgressMaximum
        {
            set
            {
                progressBar1.Maximum = value;
            }
        }

        /// <summary>
        /// Set the step value for progress bar
        /// </summary>
        public int ProgressStep
        {
            set
            {
                progressBar1.Step = value;
            }
        }

        /// <summary>
        /// Set the title of progress label
        /// </summary>
        public string ProgressBarLableTitle
        {
            set
            {
                label1.Text = value;
            }
        }
        #endregion

        #region Construtors
        /// <summary>
        /// Progress form initialization
        /// </summary>
        public ProgressForm()
        {
            InitializeComponent();
        }
        #endregion

        #region Methods
        /// <summary>
        /// Increase the value by step for progress bar
        /// </summary>
        public void PerformStep()
        {
            progressBar1.PerformStep();
        }
        #endregion
    }
}