//
// (C) Copyright 2003-2009 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

using System;
using System.Collections.Generic;
using System.Text;
using Autodesk.Revit;
using Autodesk.Revit.Parameters;

namespace Revit.SDK.Samples.RDBLink.CS
{
    public partial class TableInfoSet
    {
        #region Methods
        /// <summary>
        /// Append a TableInfo into dictionary
        /// </summary>
        /// <param name="tableinfo">TableInfo to append</param>
        /// <returns>TableInfo to append</returns>
        private TableInfo Register(TableInfo tableinfo)
        {
            Add(tableinfo.TableId, tableinfo);
            return tableinfo;
        }

        /// <summary>
        /// Append a TableInfo into dictionary and add its table id to custom table id list
        /// </summary>
        /// <param name="tableinfo">TableInfo to append</param>
        /// <returns>TableInfo to append</returns>
        protected TableInfo RegisterCustom(TableInfo tableinfo)
        {
            m_customTableIds.Add(tableinfo.TableId);
            return Register(tableinfo);
        }

        /// <summary>
        /// Initialize all TableInfos
        /// </summary>
        private void InitializeAllTableInfos()
        {
            TableInfo tableInfo = null;

            #region Symbol and Instance Tables

            tableInfo = Register(new InstanceTableInfo("TabN_OST_AreaSchemes_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.AREA_SCHEME_NAME, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");

            tableInfo = Register(new SymbolTableInfo("TabN_OST_EAConstructions_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DesignOptions_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.OPTION_SET_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.OPTION_NAME, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Materials_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MATERIAL_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Phases_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_SEQUENCE_NUMBER, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_NAME, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");

            tableInfo = Register(new InstanceTableInfo("TabN_OST_ProjectInformation_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PROJECT_ISSUE_DATE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PROJECT_STATUS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CLIENT_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PROJECT_ADDRESS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PROJECT_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PROJECT_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");

            tableInfo = Register(new SymbolTableInfo("TabN_OST_DuctTerminal_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_MAX_FLOW, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_MIN_FLOW, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_AreaLoads_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_NATURE_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_ALL_NON_0_LOADS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FZ3, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FY3, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FX3, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FZ2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FY2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FX2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FZ1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FY1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FX1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_REACTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_ID, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Casework_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CASEWORK_DEPTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.GENERIC_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FURNITURE_HEIGHT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CASEWORK_FINISH, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURTAIN_WALL_PANELS_CONSTRUCTION_TYPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Ceilings_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Columns_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_CommunicationDevices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_EAConstructions_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_EAConstructions_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_CurtainWallPanels_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CASEWORK_FINISH, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURTAIN_WALL_PANELS_CONSTRUCTION_TYPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_CurtaSystem_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_CurtainWallMullions_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_DataDevices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_ElectricalDemandFactor_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_DEMANDFACTOR_LOADCLASSIFICATION_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_DEMANDFACTOR_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_DEMANDFACTOR_DEMANDLOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DesignOptionSets_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PRIMARY_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.OPTION_SET_NAME, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PRIMARY_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_ElecDistributionSys_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DISTRIBUTIONSYS_VLL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DISTRIBUTIONSYS_VLG_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DISTRIBUTIONSYS_PHASE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DISTRIBUTIONSYS_CONFIG_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DISTRIBUTIONSYS_NUMWIRES_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Doors_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_ROUGH_WIDTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_ROUGH_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.GENERIC_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FURNITURE_HEIGHT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_OPERATION_TYPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURTAIN_WALL_PANELS_CONSTRUCTION_TYPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_FIRE_RATING, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_DuctAccessory_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_DuctFitting_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DuctSystem_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NUM_ELEMENTS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_BASE_ELEMENT_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DUCT_STATIC_PRESSURE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DUCT_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_DuctCurves_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_ElectricalCircuit_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_WIRE_NUM_RUNS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_WIRE_NUM_HOTS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_WIRE_NUM_NEUTRALS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_WIRE_NUM_GROUNDS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD_PHASEC, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD_PHASEB, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD_PHASEA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_LOAD_PHASEC, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_LOAD_PHASEB, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_LOAD_PHASEA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_CURRENT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_CURRENT_PHASEA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_CURRENT_PHASEB_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_CURRENT_PHASEC_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_CURRENT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_CURRENT_PHASEA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_CURRENT_PHASEB_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_CURRENT_PHASEC_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_VOLTAGE_DROP_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_LENGTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_RATING_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_WIRE_SIZE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_WIRE_TYPE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_TYPE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_LOAD_CLASSIFICATION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_TRUE_LOAD, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_POWER_FACTOR_STATE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_POWER_FACTOR, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_BALANCED_LOAD, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_VOLTAGE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_NUMBER_OF_POLES, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_RBS_ELEC_CIRCUIT_WIRE_TYPE_PARAM", "TabN_OST_Wire_SYMBOL", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_ElectricalEquipment_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ELECTICAL_EQUIP_VOLTAGE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ELECTICAL_EQUIP_WATTAGE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_ElectricalFixtures_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_FireAlarmDevices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_FlexDuctCurves_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_FlexPipeCurves_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_ROUGHNESS_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Floors_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_FurnitureSystems_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Furniture_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_GenericModel_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_InternalAreaLoads_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_NATURE_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_ALL_NON_0_LOADS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FZ3, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FY3, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FX3, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FZ2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FY2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FX2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FZ1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FY1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_AREA_FORCE_FX1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_REACTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_ID, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_InternalLineLoads_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_NATURE_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_ALL_NON_0_LOADS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MZ2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MY2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MX2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MZ1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MY1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MX1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FZ2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FY2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FX2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FZ1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FY1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FX1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_REACTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_UNIFORM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_ID, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_InternalPointLoads_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_NATURE_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_ALL_NON_0_LOADS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MZ, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MX, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_FORCE_FZ, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_FORCE_FY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_FORCE_FX, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_REACTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_ID, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Levels_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DATUM_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_ELEV, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Levels_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_LightingDevices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_LightingFixtures_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_PHOTOMETRIC_FILE_CACHE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_SOURCE_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_SOURCE_DIAMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_EMIT_CIRCLE_DIAMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_EMIT_RECTANGLE_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_EMIT_RECTANGLE_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_EMIT_LINE_LENGTH, DataType.DOUBLE));
            //tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_Z_ROTATION_OFFSET, DataType.DOUBLE));
            //tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_Y_ROTATION_OFFSET, DataType.DOUBLE));
            //tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_X_ROTATION_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_EMIT_SHAPE_VISIBLE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_DIMMING_LIGHT_COLOR, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_LUMENAIRE_DIRT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_LAMP_LUMEN_DEPR, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_SURFACE_LOSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_LAMP_TILT_LOSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_VOLTAGE_LOSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_TEMPERATURE_LOSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_INITIAL_COLOR_TEMPERATURE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_ILLUMINANCE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_LIMUNOUS_INTENSITY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_EFFICACY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_WATTAGE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_PHOTOMETRIC_FILE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_BALLAST_LOSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_TOTAL_LIGHT_LOSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_SPOT_FIELD_ANGLE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_SPOT_BEAM_ANGLE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_SPOT_TILT_ANGLE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FBX_LIGHT_LIMUNOUS_FLUX, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LIGHTING_FIXTURE_LAMP, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LIGHTING_FIXTURE_WATTAGE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_FAMILY_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_LineLoads_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_NATURE_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_ALL_NON_0_LOADS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MZ2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MY2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MX2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MZ1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MY1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MX1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FZ2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FY2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FX2, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FZ1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FY1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_LINEAR_FORCE_FX1, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_REACTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_UNIFORM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_ID, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_MechanicalEquipment_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_NurseCallDevices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Parking_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_PipeAccessory_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_PipeFitting_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_PipeCurves_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_ROUGHNESS_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_MATERIAL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_CONNECTIONTYPE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_CLASS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PipingSystem_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NUM_ELEMENTS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_BASE_ELEMENT_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_SYSTEM_FIXTURE_UNIT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_VOLUME_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_STATIC_PRESSURE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLUID_TYPE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLUID_TEMPERATURE_PARAM, DataType.DOUBLE));
            // tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLUID_FACTOR_PARAM, DataType.DOUBLE));
            // This parameter not exist in V2009 API. Comment out.
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLUID_VISCOSITY_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLUID_DENSITY_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Planting_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_PlumbingFixtures_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_WFU_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_HWFU_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_CWFU_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_VENT_CONNECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_WASTE_CONNECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_CW_CONNECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_HW_CONNECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PointLoads_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_NATURE_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_ALL_NON_0_LOADS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MZ, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_MOMENT_MX, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_FORCE_FZ, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_FORCE_FY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_FORCE_FX, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_IS_REACTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LOAD_CASE_ID, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_ProfileFamilies_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_SiteProperty_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_StairsRailing_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Ramps_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Roofs_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_SecurityDevices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Site_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_SpecialityEquipment_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Sprinklers_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FP_SPRINKLER_ORIFICE_SIZE_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FP_SPRINKLER_TEMPERATURE_RATING_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FP_SPRINKLER_K_FACTOR_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FP_SPRINKLER_PRESSURE_CLASS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FP_SPRINKLER_ORIFICE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FP_SPRINKLER_COVERAGE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FP_SPRINKLER_RESPONSE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Stairs_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_ATTR_TREAD_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_StructuralColumns_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_StructuralFoundation_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Truss_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_StructuralFraming_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Rebar_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            //tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_BAR_STIRRUP_BEND_DIAMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MATERIAL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_StructuralStiffener_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_SwitchSystem_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_SWITCH_ID_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_TelephoneDevices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Topography_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_ElectricalVoltage_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_VOLTAGETYPE_VOLTAGE_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_VOLTAGETYPE_MINVOLTAGE_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_VOLTAGETYPE_MAXVOLTAGE_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Walls_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_FIRE_RATING, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_ATTR_WIDTH_PARAM, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Windows_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_ROUGH_WIDTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_ROUGH_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.GENERIC_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FURNITURE_HEIGHT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_OPERATION_TYPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURTAIN_WALL_PANELS_CONSTRUCTION_TYPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Wire_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_SHARE_NEUTRAL, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_SHARE_GROUND, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_MATERIAL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_TEMPERATURE_RATING_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_INSULATION_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_MAX_CONDUCTOR_SIZE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_NEUTRAL_MULTIPLIER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_NEUTRAL_INCLUDED_IN_BALANCED_LOAD_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_NEUTRAL_MODE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_CONDUIT_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DuctTerminal_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DUCT_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_DuctTerminal_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Areas_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.AREA_SCHEME_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.AREA_TYPE_TEXT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PERIMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_LEVEL_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NAME, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_AREA_SCHEME_ID", "TabN_OST_AreaSchemes_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_ROOM_LEVEL_ID", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Casework_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Casework_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Ceilings_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_AREA_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CEILING_HEIGHTABOVELEVEL_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_PERIMETER_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Ceilings_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Columns_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_TOP_LEVEL_OFFSET_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_BASE_LEVEL_OFFSET_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_TOP_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_BASE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Columns_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_BASE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_TOP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_CommunicationDevices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_CommunicationDevices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_CurtainWallPanels_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_AREA_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURTAIN_WALL_PANELS_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURTAIN_WALL_PANELS_HEIGHT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_CurtainWallPanels_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_CurtaSystem_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_CurtaSystem_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_CurtainWallMullions_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_CurtainWallMullions_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DataDevices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_DataDevices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_ElectricalDemandFactor_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_ElectricalDemandFactor_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_ElecDistributionSys_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_ElecDistributionSys_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Doors_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_HEAD_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_SILL_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_FRAME_MATERIAL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_FRAME_TYPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CASEWORK_FINISH, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Doors_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DuctAccessory_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CALCULATED_SIZE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_DuctAccessory_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DuctFitting_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CALCULATED_SIZE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_AREA_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_DuctFitting_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_DuctCurves_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DUCT_BOTTOM_ELEVATION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DUCT_TOP_ELEVATION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CALCULATED_SIZE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SIZE_LOCK, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ADDITIONAL_FLOW, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_HYDRAULIC_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_REYNOLDSNUMBER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_EQ_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_LOSS_COEFFICIENT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_VELOCITY_PRESSURE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CURVE_SURFACE_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_LINING_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_INSULATION_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FRICTION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PRESSURE_DROP, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_VELOCITY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CURVE_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CURVE_WIDTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DUCT_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_DuctCurves_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_ElectricalEquipment_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_MODIFICATIONS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_ENCLOSURE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_MAINS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_MOUNTING, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_SHORT_CIRCUIT_RATING, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_MAX_POLE_BREAKERS, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALESTLOAD_HVAC_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALLOAD_HVAC_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALESTLOAD_LIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALLOAD_LIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALESTLOAD_POWER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALLOAD_POWER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALESTLOAD_OTHER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALLOAD_OTHER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALESTLOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_PANEL_TOTALLOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD_PHASEC, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD_PHASEB, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_APPARENT_LOAD_PHASEA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SCHEDULE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_ElectricalEquipment_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SCHEDULE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_ElectricalFixtures_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_ElectricalFixtures_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Fascia_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FASCIA_PROFILE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MATERIAL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FASCIA_PROFILE_PARAM", "TabN_OST_ProfileFamilies_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_MATERIAL_ID_PARAM", "TabN_OST_Materials_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_FireAlarmDevices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_FireAlarmDevices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_FlexDuctCurves_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SIZE_LOCK, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ADDITIONAL_FLOW, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_HYDRAULIC_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_REYNOLDSNUMBER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_EQ_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_LOSS_COEFFICIENT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_VELOCITY_PRESSURE, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_LINING_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_INSULATION_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_FRICTION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PRESSURE_DROP, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_VELOCITY, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CURVE_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CURVE_WIDTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_DUCT_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_FlexDuctCurves_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_FlexPipeCurves_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FIXTURE_UNITS_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_INSULATION_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_OUTER_DIAMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_ADDITIONAL_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_INNER_DIAM_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_REYNOLDS_NUMBER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_RELATIVE_ROUGHNESS_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLOW_STATE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FRICTION_FACTOR_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_VELOCITY_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FRICTION_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_PRESSUREDROP_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_FlexPipeCurves_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Floors_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REIN_EST_BAR_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_AREA_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FLOOR_PARAM_IS_STRUCTURAL, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_PERIMETER_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FLOOR_HEIGHTABOVELEVEL_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STRUCTURAL_FLOOR_ANALYZES_AS, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Floors_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Furniture_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Furniture_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_FurnitureSystems_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_FurnitureSystems_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_GenericModel_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_GenericModel_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Gutter_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.GUTTER_PROFILE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MATERIAL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_GUTTER_PROFILE_PARAM", "TabN_OST_ProfileFamilies_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_MATERIAL_ID_PARAM", "TabN_OST_Materials_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_LightingDevices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_SWITCH_ID_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_LightingDevices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_LightingFixtures_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_SWITCH_ID_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ROOM_COEFFICIENT_UTILIZATION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_LightingFixtures_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_MechanicalEquipment_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_MechanicalEquipment_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_NurseCallDevices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_NurseCallDevices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Parking_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Parking_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PipeAccessory_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CALCULATED_SIZE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_PipeAccessory_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PipeFitting_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CALCULATED_SIZE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_AREA_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_PipeFitting_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PipeCurves_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FIXTURE_UNITS_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_INSULATION_THICKNESS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_OUTER_DIAMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_INVERT_ELEVATION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_ADDITIONAL_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_DIAMETER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_INNER_DIAM_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_REYNOLDS_NUMBER_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_RELATIVE_ROUGHNESS_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLOW_STATE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FRICTION_FACTOR_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_VELOCITY_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FRICTION_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_PRESSUREDROP_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_CALCULATED_SIZE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SECTION, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_PipeCurves_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Planting_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Planting_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PlumbingFixtures_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_TRAP, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_DRAIN, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_SUPPLY_PIPE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PLUMBING_FIXTURES_SUPPLY_FITTING, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_PlumbingFixtures_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_SiteProperty_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PROPERTY_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_SiteProperty_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_StairsRailing_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_RAILING_HEIGHT_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_RAILING_BASE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_StairsRailing_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_STAIRS_RAILING_BASE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Ramps_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_MULTISTORY_TOP_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_TOP_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_BASE_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_ATTR_TREAD_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_TOP_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_BASE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Ramps_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_STAIRS_MULTISTORY_TOP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_STAIRS_TOP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_STAIRS_BASE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Roofs_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_AREA_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOF_RAFTER_OR_TRUSS_TEXT_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FASCIA_DEPTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOF_EAVE_CUT_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOF_BASE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOF_UPTO_LEVEL_OFFSET_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOF_UPTO_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOF_LEVEL_OFFSET_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Roofs_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_ROOF_BASE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_ROOF_UPTO_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Rooms_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PHASE_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PERIMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_LEVEL_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_OCCUPANCY, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DEPARTMENT, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_FINISH_BASE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_FINISH_CEILING, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_FINISH_WALL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_FINISH_FLOOR, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NAME, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_ROOM_PHASE_ID", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_ROOM_LEVEL_ID", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_SecurityDevices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_SecurityDevices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Site_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Site_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_MEPSpaces_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_ROOM_CAVITY_RATIO, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_ROOM_AVERAGE_ILLUMINATION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_ROOM_REFLECTIVITY_FLOOR, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_ROOM_REFLECTIVITY_WALLS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_ROOM_REFLECTIVITY_CEILING, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_ROOM_LIGHTING_CALC_WORKPLANE, DataType.DOUBLE));
            //tableInfo.Add(new ColumnInfo(BuiltInParameter.SPACE_IS_PLENUM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SPACE_IS_OCCUPIABLE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SPACE_ASSOC_ROOM_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SPACE_ASSOC_ROOM_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CALCULATED_SUPPLY_AIRFLOW_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CALCULATED_COOLING_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CALCULATED_HEATING_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_LIGHTING_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_POWER_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_BASE_HEAT_LOAD_ON_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_COOLING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CALCULATED_COOLING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_HEATING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CALCULATED_HEATING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CONSTRUCTION_SET_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PEOPLE_SENSIBLE_HEAT_GAIN_PER_PERSON_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_LIGHTING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_POWER_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_OTHER_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_MECHANICAL_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_LIGHTING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_POWER_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_OTHER_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_MECHANICAL_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_LIGHTING_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_POWER_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_EXHAUST_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_RETURN_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_ACTUAL_SUPPLY_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PEOPLE_LATENT_HEAT_GAIN_PER_PERSON_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PEOPLE_TOTAL_HEAT_GAIN_PER_PERSON_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CALCULATED_SUPPLY_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_EXHAUST_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_RETURN_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_DESIGN_SUPPLY_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_AREA_PER_PERSON_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NUMBER_OF_PEOPLE_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_SPACE_TYPE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_CONDITION_TYPE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PHASE_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_PERIMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_LEVEL_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NAME, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_ROOM_PHASE_ID", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_ROOM_LEVEL_ID", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_EdgeSlab_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SLAB_EDGE_PROFILE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MATERIAL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SLAB_EDGE_PROFILE_PARAM", "TabN_OST_ProfileFamilies_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_MATERIAL_ID_PARAM", "TabN_OST_Materials_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_SpecialityEquipment_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_SpecialityEquipment_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Sprinklers_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_SYSTEM_NAME_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_FLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_PRESSUREDROP_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Sprinklers_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Stairs_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_ACTUAL_NUM_RISERS, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_MULTISTORY_TOP_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_TOP_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_BASE_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_ACTUAL_RISER_HEIGHT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_ATTR_TREAD_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_TOP_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STAIRS_BASE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Stairs_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_STAIRS_MULTISTORY_TOP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_STAIRS_TOP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_STAIRS_BASE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_StructuralColumns_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REIN_EST_BAR_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_TOP_LEVEL_OFFSET_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_BASE_LEVEL_OFFSET_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_TOP_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_BASE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STRUCTURAL_ANALYZES_AS, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_LENGTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_StructuralColumns_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_TOP_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_BASE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_StructuralFoundation_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REIN_EST_BAR_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STRUCTURAL_FOUNDATION_LENGTH, DataType.DOUBLE));
            //tableInfo.Add(new ColumnInfo(BuiltInParameter.CONTINUOUS_FOOTING_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STRUCTURAL_FOOTING_BOTTOM_ELEVATION, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CONTINUOUS_FOOTING_WIDTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_StructuralFoundation_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_StructuralFraming_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REIN_EST_BAR_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.STRUCTURAL_FRAME_CUT_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_REFERENCE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_STRUCT_USAGE_TEXT_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_LENGTH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_StructuralFraming_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_INSTANCE_REFERENCE_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Rebar_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_STANDARD_BEND_DIAMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_SCHEDULE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_HOOK_STYLE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_SHAPE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_BAR_SPACING, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_QUANTITY_OF_BARS, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_LAYOUT_RULE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_HOOK_END_TYPE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_HOOK_START_TYPE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_ELEM_TOTAL_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REBAR_BAR_DIAMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Rebar_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_StructuralStiffener_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_StructuralStiffener_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_StructuralTruss_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Truss_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_TelephoneDevices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELECTRICAL_DATA, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_TelephoneDevices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Topography_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.VOLUME_NET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PROJECTED_SURFACE_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.VOLUME_FILL, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.VOLUME_CUT, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SURFACE_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ROOM_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Topography_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_ElectricalVoltage_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_ElectricalVoltage_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Walls_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.REIN_EST_BAR_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_AREA_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_STRUCTURAL_USAGE_TEXT_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_TOP_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_BASE_OFFSET, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_BASE_CONSTRAINT, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_USER_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_HEIGHT_TYPE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_ATTR_ROOM_BOUNDING, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Walls_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_WALL_HEIGHT_TYPE", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_WALL_BASE_CONSTRAINT", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Cornices_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_SWEEP_WALL_SUBCATEGORY_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WALL_SWEEP_PROFILE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MATERIAL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.WINDOW_TYPE_ID, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_WALL_SWEEP_PROFILE_PARAM", "TabN_OST_ProfileFamilies_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_MATERIAL_ID_PARAM", "TabN_OST_Materials_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Windows_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.FAMILY_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_HEAD_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.INSTANCE_SILL_HEIGHT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Windows_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_FAMILY_LEVEL_PARAM", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Wire_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_CIRCUIT_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_CIRCUIT_LOAD_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_WIRE_NUM_CONDUCTORS_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_TICKMARK_STATE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_PANEL_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_CIRCUITS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_TYPE, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_HOT_ADJUSTMENT, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_NEUTRAL_ADJUSTMENT, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_WIRE_GROUND_ADJUSTMENT, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_ELEC_CIRCUIT_WIRE_SIZE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Wire_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Fascia_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Fascia_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Gutter_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Gutter_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_EdgeSlab_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.HOST_VOLUME_COMPUTED, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_EdgeSlab_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Cornices_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.CURVE_ELEM_LENGTH, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DOOR_NUMBER, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Cornices_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));
            #endregion

            #region Non Symbol and Instance Tables
            tableInfo = RegisterCustom(new TableInfo("TabN_CST_AssemblyCodes", new AssemblyCodesList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_AssemblyCode", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_AssemblyDescription", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_AssemblyCode");

            tableInfo = RegisterCustom(new TableInfo("TabN_CST_RoomAssociations", new RoomAssociationsList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_PhaseId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_DesignOptionId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_RoomId", DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.PrimaryKeys.Add("ColN_CST_PhaseId");
            tableInfo.PrimaryKeys.Add("ColN_CST_DesignOptionId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_PhaseId", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_RoomId", "TabN_OST_Rooms_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = RegisterCustom(new TableInfo("TabN_CST_RoomFromToAssociations", new RoomFromToAssociationsList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_PhaseId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_DesignOptionId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_FromRoom", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_ToRoom", DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.PrimaryKeys.Add("ColN_CST_PhaseId");
            tableInfo.PrimaryKeys.Add("ColN_CST_DesignOptionId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_PhaseId", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_FromRoom", "TabN_OST_Rooms_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_ToRoom", "TabN_OST_Rooms_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = RegisterCustom(new TableInfo("TabN_CST_MaterialQuantities", new MaterialQuantitiesList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_ElementId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_MaterialId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Area", DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo("ColN_CST_Volume", DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_CST_ElementId");
            tableInfo.PrimaryKeys.Add("ColN_CST_MaterialId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_MaterialId", "TabN_OST_Materials_INSTANCE", "ColN_BP_ID_PARAM"));
            #endregion

            #region New Added Custom tables

            tableInfo = Register(new TableInfo("TabN_OST_Windows_OST_Walls", new WindowWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_WindowId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_WindowName", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_WallId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_WallName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_WindowId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_WallId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_WindowId", "TabN_OST_Windows_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_Type_Autodesk_Revit_Elements_RoomTag", new RoomTagsList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_RoomTagType", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_RoomId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_ViewId", DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");

            tableInfo = RegisterCustom(new TableInfo("TabN_CST_Categories", new CategoriesList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_MaterialId", DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_MaterialId", "TabN_OST_Materials_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_Type_Autodesk_Revit_Elements_Opening", new OpeningsList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_LevelId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");

            tableInfo = Register(new TableInfo("TabN_OST_LineLoads_OST_StructuralFraming", new LineLoadOnBeamList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_LineLoadId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_BeamId", DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_CST_LineLoadId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_BeamId", "TabN_OST_StructuralFraming_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_LineLoadId", "TabN_OST_LineLoads_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_AreaLoads_OST_Floors", new AreaLoadOnSlabList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_AreaLoadId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_SlabId", DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_CST_AreaLoadId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_AreaLoadId", "TabN_OST_AreaLoads_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_SlabId", "TabN_OST_Floors_INSTANCE", "ColN_BP_ID_PARAM"));


            tableInfo = Register(new TableInfo("TabN_CST_ElementLevel", new ElementLevelList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_ElementId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_ElementName", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_LevelId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_LevelName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_ElementId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_LevelId", "TabN_OST_Levels_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_CST_ElementPhase", new ElementPhaseList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_ElementId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_ElementName", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_PhaseCreatedId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_PhaseName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_ElementId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_PhaseCreatedId", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_Doors_OST_Walls", new DoorWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_DoorId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_DoorName", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_WallId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_WallName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_DoorId");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_DoorId", "TabN_OST_Doors_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_WallId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));


            tableInfo = Register(new TableInfo("TabN_OST_Rebar_OST_Floors", new RebarOnFloorList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_Rebar_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Floors_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_Type_Opening_OST_Floors", new OpeningOnFloorList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_Type_Autodesk_Revit_Elements_Opening", "ColN_CST_Id"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Floors_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_Rebar_OST_StructuralColumns", new RebarOnColumnList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_Rebar_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_StructuralColumns_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_CurtainWallPanels_OST_Roofs", new CurtainWallPanelOnRoofList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_CurtainWallPanels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Roofs_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_GenericModel_OST_Roofs", new GenericModelOnRoofList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_GenericModel_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Roofs_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_LightingFixtures_OST_Ceilings", new LightingFixtureOnCeilingList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_LightingFixtures_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Ceilings_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_MechanicalEquipment_OST_Walls", new MechanicalEquipmentOnWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_MechanicalEquipment_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_CurtainWallPanels_OST_Walls", new CurtainWallPanelOnWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_CurtainWallPanels_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_LightingFixtures_OST_Walls", new LightingFixtureOnWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_LightingFixtures_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_PlumbingFixtures_OST_Walls", new PlumbingFixtureOnWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_PlumbingFixtures_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_Type_Opening_OST_Walls", new OpeningOnWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_Type_Autodesk_Revit_Elements_Opening", "ColN_CST_Id"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_GenericModel_OST_Walls", new GenericModelOnWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_GenericModel_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new TableInfo("TabN_OST_Casework_OST_Walls", new CaseworkOnWallList()));
            tableInfo.Add(new ColumnInfo("ColN_CST_Id", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_Name", DataType.TEXT));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostId", DataType.INTEGER));
            tableInfo.Add(new ColumnInfo("ColN_CST_HostName", DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_CST_Id");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_Id", "TabN_OST_Casework_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_CST_HostId", "TabN_OST_Walls_INSTANCE", "ColN_BP_ID_PARAM"));

            #endregion

            #region New added tables in Version 2009

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Levels_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Fluids_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_HVAC_Zones_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_USE_AIR_CHANGES_PER_HOUR_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_USE_OUTSIDE_AIR_PER_AREA_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_USE_OUTSIDE_AIR_PER_PERSON_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_USE_DEHUMIDIFICATION_SETPOINT_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_USE_HUMIDIFICATION_SETPOINT_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_AREA_GROSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_VOLUME_GROSS, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_PHASE_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_CALCULATED_SUPPLY_AIRFLOW_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_CALCULATED_COOLING_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_CALCULATED_HEATING_LOAD_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_LEVEL_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_OA_RATE_PER_ACH_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_OUTSIDE_AIR_PER_AREA_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_OUTSIDE_AIR_PER_PERSON_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_DEHUMIDIFICATION_SET_POINT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_HUMIDIFICATION_SET_POINT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_COOLING_AIR_TEMPERATURE_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_HEATING_AIR_TEMPERATURE_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_COOLING_SET_POINT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_HEATING_SET_POINT_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_CALCULATED_SUPPLY_AIRFLOW_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_CALCULATED_COOLING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_CALCULATED_HEATING_LOAD_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_SERVICE_TYPE_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_PERIMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ZONE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_PipeConnections_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_PipeMaterials_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.RBS_PIPE_ROUGHNESS_PARAM, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_PipeSchedules_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Fluids_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Fluids_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PipeConnections_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_PipeConnections_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PipeMaterials_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_PipeMaterials_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_PipeSchedules_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_PipeSchedules_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_WireInsulations_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_WireInsulations_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_WireInsulations_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_WireMaterials_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_WireMaterials_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_WireMaterials_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_WireTemperatureRatings_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_WireTemperatureRatings_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_WireTemperatureRatings_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_Mass_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MASS_GROSS_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MASS_GROSS_SURFACE_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.MASS_GROSS_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SCHEDULE_BASE_LEVEL_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_Mass_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_Mass_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            tableInfo = Register(new InstanceTableInfo("TabN_OST_MassAreaFaces_INSTANCE"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.SYMBOL_ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_CREATED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.PHASE_DEMOLISHED, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.DESIGN_OPTION_ID, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_MASS_TYPE_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_MASS_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_MASS_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_MASS_FAMILY_AND_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_MASS_FAMILY_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_SPACE_USAGE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_OWNING_LEVEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_MASS_TYPE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_VOLUME, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_SURFACE_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_FLOOR_AREA, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.LEVEL_DATA_FLOOR_PERIMETER, DataType.DOUBLE));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_INSTANCE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MARK, DataType.TEXT));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_SYMBOL_ID_PARAM", "TabN_OST_MassAreaFaces_SYMBOL", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_CREATED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_PHASE_DEMOLISHED", "TabN_OST_Phases_INSTANCE", "ColN_BP_ID_PARAM"));
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_DESIGN_OPTION_ID", "TabN_OST_DesignOptions_INSTANCE", "ColN_BP_ID_PARAM"));

            tableInfo = Register(new SymbolTableInfo("TabN_OST_MassAreaFaces_SYMBOL"));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ID_PARAM, DataType.INTEGER));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.KEYNOTE_PARAM, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MODEL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_MANUFACTURER, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_COMMENTS, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_URL, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_DESCRIPTION, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.UNIFORMAT_CODE, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_FAMILY_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_NAME, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_TYPE_MARK, DataType.TEXT));
            tableInfo.Add(new ColumnInfo(BuiltInParameter.ALL_MODEL_COST, DataType.DOUBLE));
            tableInfo.PrimaryKeys.Add("ColN_BP_ID_PARAM");
            tableInfo.ForeignKeys.Add(new ForeignKey("ColN_BP_UNIFORMAT_CODE", "TabN_CST_AssemblyCodes", "ColN_CST_AssemblyCode"));

            #endregion
        }
        #endregion
    }
}
