#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using System.IO;
#endregion

namespace ReadCsvPoints
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      string filepath = "insert file path here";

      if( File.Exists( filepath ) )
      {
        StreamReader s = new StreamReader( 
          filepath );

        while( -1 != s.Peek() )
        {
          string line = s.ReadLine();

          string[] data = line.Split( 
            new char[] { ',' } );

          XYZ p = app.Create.NewXYZ( 
            double.Parse( data[0] ), 
            double.Parse( data[1] ), 
            double.Parse( data[2] ) );

          ReferencePoint rp = doc.FamilyCreate
            .NewReferencePoint( p );
        }
      }

      return Result.Succeeded;
    }
  }
}
