#region Namespaces
using System;
using System.Collections.Generic;
using System.Linq;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.DB.Electrical;
using System.Diagnostics;
#endregion

namespace ReadWireSizes
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Document doc = uidoc.Document;

      // Retrieve TemperatureRatingType from
      // filtered element collector; their
      // wire sizes cannot be accessed:

      FilteredElementCollector col 
        = new FilteredElementCollector( doc )
          .OfClass( typeof( TemperatureRatingType ) );

      IEnumerable<TemperatureRatingType> trEnumerable 
        = col.ToElements().Cast<TemperatureRatingType>();

      var TempRatingReturn 
        = from rtelement in trEnumerable
          where rtelement.Name == "60"
          select rtelement;

      // The wire sizes we are searching for:
     
      WireSizeSet wsset = null;

      // Keep track of the target TemperatureRatingType:

      ElementId rtId = null;
      
      foreach( TemperatureRatingType rt 
        in TempRatingReturn )
      {
        try
        {
          rtId = rt.Id;

          // This call fails:

          wsset = rt.WireSizes;
        }
        catch( NullReferenceException ex )
        {
          Debug.Print( ex.GetType().ToString() 
            + ": " + ex.Message );

          Debug.Assert( ex.Message.Equals( 
            "Object reference not set to an instance of an object." ), 
            "expected null reference exception" );
        }
      }

      // Iterate over the electrical settings 
      // wire material types and use the target 
      // element id to identify the proper
      // TemperatureRatingType:

      WireMaterialTypeSet wts = doc.Settings
        .ElectricalSetting.WireMaterialTypes;

      foreach( WireMaterialType wt in wts )
      {
        foreach( TemperatureRatingType rt 
          in wt.TemperatureRatings )
        {
          if( rtId == rt.Id )
          {
            wsset = rt.WireSizes;
          }
        }
      }

      int n = wsset.Size;

      Debug.Print( string.Format(
        "{0} wire size{1} stored on temperature "
        + "rating type with element id {2}",
        n, ( 1 == n ? "" : "s" ), rtId ) );

      return Result.Succeeded;
    }
  }
}

// C:\Program Files\Autodesk\Revit MEP 2012\Program\Samples\rme_advanced_sample_project.rvt
