﻿using System;
using System.Collections.Generic;
using System.Linq;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System.Text;

namespace ReloadFamilySample
{
  [Transaction( TransactionMode.Manual )]
  [Regeneration( RegenerationOption.Manual )]
  public class Class1 : IExternalCommand
  {
    Result IExternalCommand.Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication app = commandData.Application;
      Document doc = app.ActiveUIDocument.Document;
      UIDocument uidoc = new UIDocument( doc );

      Transaction trans = new Transaction( doc, "ExComm" );
      trans.Start();

      Autodesk.Revit.UI.Selection.SelElementSet collection = uidoc.Selection.Elements;

      foreach( FamilyInstance e in collection )
      {
        if( e.Category.Name == "Structural Framing" )
        {
          // example works best when familyInstance is a rectangular concrete element 
          if( null != e.Symbol )
          {
            // Get family associated with this 
            Family family = e.Symbol.Family;

            FamilySymbolSet symbolSet = family.Symbols;
            Boolean bTypeXXExist = false;
            foreach( FamilySymbol symbol in symbolSet )
            {
              if( symbol.Name.Equals( "xx" ) == true )
              {
                bTypeXXExist = true;
                break;
              }
            }

            if( !bTypeXXExist )
            {

              // Get Family document for family 
              Document familyDoc = doc.EditFamily( family );

              if( null != familyDoc )
              {
                Transaction transFamDoc = new Transaction( familyDoc );
                transFamDoc.Start( "EditFamily" );
                FamilyManager familyManager = familyDoc.FamilyManager;
                // add a new type and edit its parameters 

                FamilyType newFamilyType = familyManager.NewType( "xx" );

                // look for 'b' and 'h' parameters and set them to 2 feet 
                FamilyParameter familyParam = familyManager.get_Parameter( "b" );
                if( null != familyParam )
                {
                  familyManager.Set( familyParam, 100 );
                }
                familyParam = familyManager.get_Parameter( "h" );
                if( null != familyParam )
                {
                  familyManager.Set( familyParam, 1600 );
                }
                transFamDoc.Commit();

                // now update the Revit project with Family which has a new type 
                family = familyDoc.LoadFamily( doc, new FamilyOption() );
              }

              // find the new type and assign it to FamilyInstance 
              FamilySymbolSetIterator symbolsItor = family.Symbols.ForwardIterator();
              symbolsItor.Reset();
              while( symbolsItor.MoveNext() )
              {
                FamilySymbol familySymbol = symbolsItor.Current as FamilySymbol;
                if( familySymbol.Name == "xx" )
                {
                  e.Symbol = familySymbol;

                  break;
                }
              }
            }
          }
        }
      }
      trans.Commit();
      return Result.Succeeded;
    }
  }

  class FamilyOption : IFamilyLoadOptions
  {
    public bool OnFamilyFound(
      bool familyInUse,
      ref bool overwriteParameterValues )
    {
      overwriteParameterValues = true;
      return true;
    }

    public bool OnSharedFamilyFound(
      Family sharedFamily,
      bool familyInUse,
      ref FamilySource source,
      ref bool overwriteParameterValues )
    {
      return true;
    }
  }

  [Transaction( TransactionMode.Manual )]
  [Regeneration( RegenerationOption.Manual )]
  public class Command1 : IExternalCommand
  {
    public UIApplication app;
    public Document doc;
    public UIDocument uidoc;

    Result IExternalCommand.Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      app = commandData.Application;
      doc = app.ActiveUIDocument.Document;
      uidoc = new UIDocument( doc );

      Transaction trans = new Transaction( doc );
      trans.Start( "changeSymbol" );

      Selection sel = uidoc.Selection;

      Reference ref1 = sel.PickObject(
        ObjectType.Element,
        "Please pick a family instance" );

      FamilyInstance famInstance = ref1.Element as FamilyInstance;

      FamilySymbol famSymbol = famInstance.Symbol;

      ICollection<ElementId> symbols = famSymbol.GetSimilarTypes();

      FamilySymbol famSymbolOther = null;

      foreach( ElementId id in symbols )
      {
        if( false == id.Equals( famSymbol.Id ) )
        {
          famSymbolOther = doc.get_Element( id ) as FamilySymbol;
          break;
        }
      }

      if( famSymbolOther != null )
      {
        famInstance.Symbol = famSymbolOther;
      }

      trans.Commit();

      return Result.Succeeded;
    }
  }
}
