﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit;
using Options = Autodesk.Revit.Geometry.Options;

namespace RemoveRfaGeom
{
  public class Command : IExternalCommand
  {
    public IExternalCommand.Result Execute( 
      ExternalCommandData commandData, 
      ref string message, 
      ElementSet elements )
    {
      Application app = commandData.Application;
      Document doc = app.ActiveDocument;

      ElementIterator it = doc.Elements;
      Options opt = app.Create.NewGeometryOptions();
      List<Element> a = new List<Element>();

      while( it.MoveNext() )
      {
        Element e = it.Current as Element;

        if( null != e.get_Geometry( opt ) )
        {
          a.Add( e );
        }
      }

      int n = a.Count;
      Debug.Print( 
        "{0} element{1} have non-null geometry{2}", 
        n, 
        ( 1 == n ? "" : "s" ),
        ( 0 == n ? "." : ":" ) );

      ElementSet els = new ElementSet();

      foreach( Element e in a )
      {
        string cat = (null == e.Category)
          ? "<null>"
          : e.Category.Name;

        Debug.Print(
          "Category={0}; Name={1}; Id={2}; Type={3}",
          cat,
          e.Name,
          e.Id.Value.ToString(),
          e.GetType().Name );

        if( null == e.Category )
        {
          els.Insert( e );
        }
      }

      ElementIdSet ids = doc.Delete( els );

      n = (null == ids) ? 0 : ids.Size;

      Debug.Print( "{0} element{1} deleted.",
        n,
        ( 1 == n ? "" : "s" ) );

      return IExternalCommand.Result.Succeeded;
    }
  }
}
