﻿#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Events;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Events;
#endregion

namespace RenDocOnSave
{
  class App : IExternalApplication
  {
    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }

    public Result OnStartup( UIControlledApplication a )
    {
      a.ControlledApplication.DocumentSavingAs 
        += new EventHandler<DocumentSavingAsEventArgs>( 
          OnDocumentSavingAs );

      a.ControlledApplication.DocumentSavedAs 
        += new EventHandler<DocumentSavedAsEventArgs>( 
          OnDocumentSavedAs );

      return Result.Succeeded;
    }

    bool reentering = false;

    void OnDocumentSavingAs( 
      object sender, 
      DocumentSavingAsEventArgs e )
    {
      try
      {
        if( !reentering )
        {
          Document doc = e.Document;

          e.Cancel();

          reentering = true;

          UIApplication uiApp 
            = new UIApplication( doc.Application );

          uiApp.Idling 
            += new EventHandler<IdlingEventArgs>( 
              OnIdling );
        }
      }
      catch( System.Exception ex )
      {
        TaskDialog.Show( "Exception in SavingAs", 
          ex.ToString() );
      }
    }

    void OnDocumentSavedAs( 
      object sender, 
      DocumentSavedAsEventArgs e )
    {
      try
      {
        if( e.Status != RevitAPIEventStatus.Cancelled )
        {
          reentering = false;
        }
      }
      catch( System.Exception ex )
      {
        TaskDialog.Show( "Exception in SavedAs", 
          ex.ToString() );
      }
    }

    void OnIdling( object sender, IdlingEventArgs e )
    {
      //Application app = (Application) sender; // 2011
      //UIApplication uiApp = new UIApplication( app ); // 2011

      UIApplication uiApp = sender as UIApplication; // 2012

      Document doc = uiApp.ActiveUIDocument.Document;

      string filename = @"C:\foo.rvt";

      // warning CS0618: 
      // Autodesk.Revit.DB.Document.SaveAs(string, bool) is obsolete: 
      // This method is obsolete, use SaveAs(String, SaveAsOptions) instead.
      //doc.SaveAs( filename, true );

      // SaveAsOptions.Rename essentially does what the old option did 
      // – it either kept the document in memory with the original name, 
      // or renamed it in memory.  If the latter, the UI is one place 
      // where the new name appears.

      SaveAsOptions options = new SaveAsOptions();
      options.OverwriteExistingFile = true;
      options.Rename = true;

      doc.SaveAs( filename, options );

      uiApp.Idling -= OnIdling;
    }
  }
}
