﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Runtime.InteropServices;
using System.Security;
using System.Windows.Interop;
using HelixToolkit.Wpf;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media.Media3D;
//using System.Diagnostics.CodeAnalysis;


namespace ModelViewer
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        #region Inter Process Communication (IPC) related properties
        //this timer will be used to check every 300 milliseconds whether there are messages from revit to process, or messages to send to revit
        System.Windows.Threading.DispatcherTimer dispatcherTimer = new System.Windows.Threading.DispatcherTimer();
        public static Queue<string> BrowserToRevitActions = new Queue<string>();
        public static Queue<string> RevitToBrowserActions = new Queue<string>();

        //these properties will be set on startup from the startup arguments, by eventhandler "Application_Startup" defined in App.xaml.cs
        public static bool StartedByRevitAddin = false;
        public static IntPtr revit_hwnd;

        //this property will be set when the viewer window is shown in the constructor 
        public static IntPtr viewer_hwnd;
        #endregion

        //model paths
        private string STAND_ALONE_MODEL_PATH = @"C:\Users\Jesse-M\Downloads\low poly buildings.obj";
        //private string STAND_ALONE_MODEL_PATH = @"C:\Program Files\MyFirstObjFile.obj";
        private string REVIT_MODEL_EXPORT_PATH = @"C:\ProgramData\Autodesk\Revit\Addins\2018\Revit External Model Viewer\ViewerContent.obj";

        public MainWindow()
        {
            InitializeComponent();

            #region setup the inter process communication with revit
            viewer_hwnd = new WindowInteropHelper(this).EnsureHandle();
            HwndSource source = HwndSource.FromHwnd(viewer_hwnd);
            source.AddHook(new HwndSourceHook(WndProc));

            dispatcherTimer.Tick += new EventHandler(dispatcherTimer_Tick);
            dispatcherTimer.Interval = new TimeSpan(0, 0, 0, 0, 300);
            dispatcherTimer.Start();
            #endregion

            string MODEL_PATH = StartedByRevitAddin ? REVIT_MODEL_EXPORT_PATH : STAND_ALONE_MODEL_PATH;   

            //load and display a 3D file in the viewer
            ModelVisual3D device3D = new ModelVisual3D();
            device3D.Content = Display3d(MODEL_PATH);
            viewPort3d.Children.Add(device3D);
        }

        private Model3D Display3d(string modelFullPath)
        {
            Model3D device = null;
            try
            {
                //Adding a gesture here
                viewPort3d.RotateGesture = new MouseGesture(MouseAction.LeftClick);

                //Import 3D model file
                ModelImporter import = new ModelImporter();

                //set the color of the imported model default to Snow
                import.DefaultMaterial = new DiffuseMaterial(new SolidColorBrush(Colors.Snow));

                //Load the 3D model file
                device = import.Load(modelFullPath);                
                
            }
            catch (Exception e)
            {
                // Handle exception in case can not file 3D model
                MessageBox.Show("Exception Error : " + e.StackTrace);
            }
            return device;
        }

        #region Inter Process Communication (IPC) related functions
        private void dispatcherTimer_Tick(object sender, EventArgs e)
        {

            if (BrowserToRevitActions.Count > 0)
            {
                this.Visibility = Visibility.Collapsed;
                string action = BrowserToRevitActions.Dequeue();
                sendMessage(action);
            }

            if (RevitToBrowserActions.Count > 0)
            {
                string action = RevitToBrowserActions.Dequeue();
                // call a javascript-method in the html-file
                //browser.ExecuteScriptAsync("receiveFromRevit", new string[] { action });
                //execute viewer


            }

        }
        public void sendTextToRevit(string message)
        {
            BrowserToRevitActions.Enqueue(message);
        }
        #region code from https://code.msdn.microsoft.com/windowsapps/CSReceiveWMCOPYDATA-dbbc7ed7/sourcecode?fileId=21692&pathId=224762670

        private void sendMessage(string message)
        {

            // Prepare the COPYDATASTRUCT struct with the data to be sent. 
            MyStruct myStruct;

            myStruct.Message = message;

            // Marshal the managed struct to a native block of memory. 
            int myStructSize = Marshal.SizeOf(myStruct);
            IntPtr pMyStruct = Marshal.AllocHGlobal(myStructSize);
            try
            {
                Marshal.StructureToPtr(myStruct, pMyStruct, true);

                COPYDATASTRUCT cds = new COPYDATASTRUCT();
                cds.cbData = myStructSize;
                cds.lpData = pMyStruct;

                // Send the COPYDATASTRUCT struct through the WM_COPYDATA message to  
                // the receiving window. (The application must use SendMessage,  
                // instead of PostMessage to send WM_COPYDATA because the receiving  
                // application must accept while it is guaranteed to be valid.) 
                NativeMethod.SendMessage(revit_hwnd, WM_COPYDATA, viewer_hwnd, ref cds);

                int result = Marshal.GetLastWin32Error();
                if (result != 0)
                {
                    // sometimes there's a false alarm here... remove the msgbox
                    //MessageBox.Show(String.Format(
                    //    "SendMessage(WM_COPYDATA) (Browser->Revit) failed w/err 0x{0:X}", result));
                }
            }
            finally
            {
                Marshal.FreeHGlobal(pMyStruct);
            }

        }

        

        private IntPtr WndProc(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, ref bool handled)
        {
            //  do stuff
            if(msg == WM_COPYDATA)
            {
                COPYDATASTRUCT cds = (COPYDATASTRUCT)Marshal.PtrToStructure(lParam, typeof(COPYDATASTRUCT));
                // If the size matches 
                if (cds.cbData == Marshal.SizeOf(typeof(MyStruct)))
                {
                    // Marshal the data from the unmanaged memory block to a  
                    // MyStruct managed struct. 
                    MyStruct myStruct = (MyStruct)Marshal.PtrToStructure(cds.lpData,
                        typeof(MyStruct));

                    RevitToBrowserActions.Enqueue(myStruct.Message);

                    // show the window again
                    this.Activate();

                }
            }

            return IntPtr.Zero;
        }


        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
        internal struct MyStruct
        {
            // Kim: use 4 MB message size. Using a dynamic size is probably possible, but would require some Googling 
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4096)]
            public string Message;
        }

        /// <summary> 
        /// An application sends the WM_COPYDATA message to pass data to another  
        /// application 
        /// </summary> 
        internal const int WM_COPYDATA = 0x004A;

        /// <summary> 
        /// The COPYDATASTRUCT structure contains data to be passed to another  
        /// application by the WM_COPYDATA message.  
        /// </summary> 
        [StructLayout(LayoutKind.Sequential)]
        internal struct COPYDATASTRUCT
        {
            public IntPtr dwData;       // Specifies data to be passed 
            public int cbData;          // Specifies the data size in bytes 
            public IntPtr lpData;       // Pointer to data to be passed 
        }

        /// <summary> 
        /// The class exposes Windows APIs to be used in this code sample. 
        /// </summary> 
        [SuppressUnmanagedCodeSecurity]
        internal class NativeMethod
        {
            /// <summary> 
            /// Sends the specified message to a window or windows. The SendMessage  
            /// function calls the window procedure for the specified window and does  
            /// not return until the window procedure has processed the message.  
            /// </summary> 
            /// <param name="hWnd"> 
            /// Handle to the window whose window procedure will receive the message. 
            /// </param> 
            /// <param name="Msg">Specifies the message to be sent.</param> 
            /// <param name="wParam"> 
            /// Specifies additional message-specific information. 
            /// </param> 
            /// <param name="lParam"> 
            /// Specifies additional message-specific information. 
            /// </param> 
            /// <returns></returns> 
            [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
            public static extern IntPtr SendMessage(IntPtr hWnd, int Msg,
                IntPtr wParam, ref COPYDATASTRUCT lParam);


            /// <summary> 
            /// The FindWindow function retrieves a handle to the top-level window  
            /// whose class name and window name match the specified strings. This  
            /// function does not search child windows. This function does not  
            /// perform a case-sensitive search. 
            /// </summary> 
            /// <param name="lpClassName">Class name</param> 
            /// <param name="lpWindowName">Window caption</param> 
            /// <returns></returns> 
            [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
            public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);
        }

        #endregion
        #endregion
    }
}
