﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ObjExporter.Model
{
    public class ExportOptions
    {
        // properties

        public bool IncludeLinks { get; set; }
        public bool IncludeInstances { get; set; }
        public bool IncludeFaces { get; set; }
        public bool IncludeMeshes { get; set; }
        public bool IncludeMaterials { get; set; }
        public bool ApplyTransforms { get; set; }

        // Default constructor

        public ExportOptions()
        {
            IncludeLinks = true;
            IncludeInstances = true;
            IncludeFaces = true;
            IncludeMeshes = true;
            IncludeMaterials = true;
            ApplyTransforms = true;
        }

        // copy constructor

        public ExportOptions(ExportOptions other)
        {
            IncludeLinks = other.IncludeLinks;
            IncludeInstances = other.IncludeInstances;
            IncludeFaces = other.IncludeFaces;
            IncludeMeshes = other.IncludeMeshes;
            IncludeMaterials = other.IncludeMaterials;
            ApplyTransforms = other.ApplyTransforms;
        }
    }
}
