﻿using System;
using System.Collections.Generic;
using Autodesk.Revit.DB;

namespace ObjExporter.Model
{
    /// <summary>
    /// A local class for caching materials during the rendering process
    /// </summary>
    class Materials
    {
        // List of material Ids used during the export
        // Kept in order to optimize the output (by not exporting the same material twice)

        private ElementId m_currentMaterial = ElementId.InvalidElementId;
        private List<ElementId> m_materialIds = new List<ElementId>();

        public bool IsCurrent(ElementId matId)
        {
            return (m_currentMaterial == matId) && (matId != ElementId.InvalidElementId);
        }

        // Cache a material; It'll be added if it has not been used before;
        // If it is added, this method returns TRUE, otherwise it returns FALSE.
        // The given material will be remembered as the current one.

        public bool Add(ElementId matId)
        {
            m_currentMaterial = matId;

            if (matId == ElementId.InvalidElementId)
            {
                return false;
            }

            if (m_materialIds.Contains(matId))
            {
                return false;
            }

            m_materialIds.Add(matId);
            return true;
        }

        // Reset the current material

        public void ResetCurrent()
        {
            m_currentMaterial = ElementId.InvalidElementId;
        }
    }
}
