﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Events;

namespace RevitPlugin
{
    public class ExternalApplication : IExternalApplication
    {
        #region IPC related properties
        //these properties are related to the Inter Process Communication used for communication with the viewer
        //This code is derived from https://thebuildingcoder.typepad.com/blog/2019/04/set-floor-level-and-use-ipc-for-disentanglement.html#6
        
        // create an object taking care of the messaging (an invisible Forms.Form)
        public static MessageHandler messagehandler = new MessageHandler();

        public const int WM_SYSCOMMAND = 0x0112;
        public const int SC_CLOSE = 0xF060;

        [DllImport("user32.dll")]
        public static extern IntPtr SendMessage(IntPtr hWnd, uint Msg, int wParam, int lParam);
        #endregion

        public Result OnShutdown(UIControlledApplication application)
        {
            // make sure the viewer process is closed when revit shuts down
            if (MessageHandler.viewer_ProcessId != 0)
            {
                // this could be enough, but rather try to close the process 
                //SendMessage(MessageHandler.browser_hwnd, WM_SYSCOMMAND, SC_CLOSE, 0);

                //retrieve all processes running on the computer, loop through them and find the viewer
                Process[] processes = Process.GetProcesses();

                foreach (Process p in processes)
                {
                    if (p.Id == MessageHandler.viewer_ProcessId)
                    {
                        IntPtr hwnd = p.MainWindowHandle;
                        SendMessage(hwnd, WM_SYSCOMMAND, SC_CLOSE, 0);
                        break;
                    }
                }
            }
            return Result.Succeeded;
        }

        public Result OnStartup(UIControlledApplication application)
        {
            //subscribe the eventhandler "application_Idling" to the event "application.Idling", which enables runnning any Revit actions outside of the command
            application.Idling += application_Idling;

            //create a button on a ribbon panel which can be used to show the viewer
            RibbonPanel panel = application.CreateRibbonPanel("testing ext. process");
            PushButton pushButton = panel.AddItem(new PushButtonData("Open viewer", "Open viewer", new System.Uri(System.Reflection.Assembly.GetExecutingAssembly().CodeBase).LocalPath, "RevitPlugin.Controller")) as PushButton;

            // set a tooltip and the contextual help
            pushButton.ToolTip = "Open a viewer as external process";
            string LMurl = "http://www.prodlib.com";
            ContextualHelp LMcontextHelp = new ContextualHelp(ContextualHelpType.Url, LMurl);
            pushButton.SetContextualHelp(LMcontextHelp);

            //return 
            return Result.Succeeded;
        }

        public void application_Idling(object sender, IdlingEventArgs e)
        {
            // get the UIApplication object, which opens the Revit API for you...
            UIApplication uiApp = sender as UIApplication;

            if (MessageHandler.ViewerToRevitActions.Count > 0)
            {
                string action = MessageHandler.ViewerToRevitActions.Dequeue();

                // do your Revit tasks here
                MessageBox.Show("Text received from the browser window: " + action);

                // reply something back
                MessageHandler.RevitToViewerActions.Enqueue("A message from the Revit plugin - " + DateTime.Now.ToString());

            }

        }
    }
}
