
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO;

using Autodesk.Revit;
using Autodesk.Revit.Parameters;
using Autodesk.Revit.Geometry;
using Autodesk.Revit.Elements;
using Autodesk.Revit.Symbols;
using Autodesk.Revit.Enums;
using RvtElemets = Autodesk.Revit.Elements;

namespace RevitTest
{
    /// <summary>
    /// To add an external command to Autodesk Revit 
    /// the developer should implement an object that 
    /// supports the IExternalCommand interface.
    /// </summary>
    public class CmdRevitTest : IExternalCommand
    {

        public IExternalCommand.Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {
            // result of command
            IExternalCommand.Result result = IExternalCommand.Result.Failed;

            try
            {
                DialogResult dlgRes = MessageBox.Show("Start the Form modeless?", "Revit Test", MessageBoxButtons.YesNo);

                Autodesk.Revit.Application revitApp = commandData.Application;

                Form1 form = new Form1(revitApp);
                if (dlgRes == DialogResult.Yes)
                {
                    form.Show();
                }
                else
                {
                    form.ShowDialog();
                }
            }
            catch (Exception ex)
            {
                ShowException(ex);
                result = IExternalCommand.Result.Failed;
            }

            return result;
        }

        public static void ShowException(Exception ex)
        {
            StringBuilder sb = new StringBuilder();

            sb.AppendFormat("{0}\r\n", ex.Message);
            sb.AppendFormat("\r\nException Type:{0}\r\n", ex.GetType().FullName);
            sb.AppendFormat("\r\nin:\r\n{0}", ex.StackTrace);

            string title = string.Format("Exception in {0}", Path.GetFileNameWithoutExtension(typeof(CmdRevitTest).Assembly.Location));
            MessageBox.Show(sb.ToString(), title);
        }
    }
}
