﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.IO;
using WinForms = System.Windows.Forms;

using Rvt = Autodesk.Revit;
using Autodesk.Revit.Parameters;
using Autodesk.Revit.Geometry;
using Autodesk.Revit.Elements;
using Autodesk.Revit.Symbols;
using Autodesk.Revit.Enums;
using RvtElemets = Autodesk.Revit.Elements;

namespace RevitTest
{
    public partial class Form1 : WinForms.Form, Rvt.IFamilyLoadOptions
    {
        private Rvt.Application m_revitApp;

        public Form1(Rvt.Application revitApp)
        {
            m_revitApp = revitApp;

            InitializeComponent();
        }

        private void bnLoadFamily_Click(object sender, EventArgs e)
        {
            Rvt.Document doc = m_revitApp.ActiveDocument;

            WinForms.OpenFileDialog dlg = new WinForms.OpenFileDialog();
            dlg.Filter = "Revit Family files (*.rfa)|*.rfa";
            dlg.CheckFileExists = true;
            if (dlg.ShowDialog() == WinForms.DialogResult.OK)
            {
                string filename = dlg.FileName;
                Family family = null;
                if (doc.LoadFamily(filename, out family))
                {
                    Rvt.Document projectDoc = doc;
                    Rvt.Document familyDoc = projectDoc.EditFamily(family);
                    if (null != familyDoc)
                    {
                        try
                        {
                            // TBD: make changes here...

                            // now load the family document into the target document
                            family = familyDoc.LoadFamily(projectDoc);
                        }
                        catch (System.Exception ex)
                        {
                            ShowException(ex);
                        }

                        familyDoc.Close(false);
                    }

                    WinForms.MessageBox.Show("Success");
                }
            }
        }

        private void bnLoadFamilyWithILoadOptions_Click(object sender, EventArgs e)
        {
            Rvt.Document doc = m_revitApp.ActiveDocument;

            WinForms.OpenFileDialog dlg = new WinForms.OpenFileDialog();
            dlg.Filter = "Revit Family files (*.rfa)|*.rfa";
            dlg.CheckFileExists = true;
            if (dlg.ShowDialog() == WinForms.DialogResult.OK)
            {
                string filename = dlg.FileName;
                Family family = null;
                if (doc.LoadFamily(filename, out family))
                {
                    Rvt.Document projectDoc = doc;
                    Rvt.Document familyDoc = projectDoc.EditFamily(family);
                    if (null != familyDoc)
                    {
                        try
                        {
                            // TBD: make changes here...

                            // now load the family document into the target document
                            family = familyDoc.LoadFamily(projectDoc, this);
                        }
                        catch (System.Exception ex)
                        {
                            ShowException(ex);
                        }

                        familyDoc.Close(false);
                    }

                    WinForms.MessageBox.Show("Success");
                }
            }
        }


        public static void ShowException(Exception ex)
        {
            StringBuilder sb = new StringBuilder();

            sb.AppendFormat("{0}\r\n", ex.Message);
            sb.AppendFormat("\r\nException Type:{0}\r\n", ex.GetType().FullName);
            sb.AppendFormat("\r\nin:\r\n{0}", ex.StackTrace);

            string title = string.Format("Exception in {0}", Path.GetFileNameWithoutExtension(typeof(Form1).Assembly.Location));
            WinForms.MessageBox.Show(sb.ToString(), title);
        }

        #region IFamilyLoadOptions Interface methods

        /// <summary>
        /// 
        /// </summary>
        /// <param name="familyInUse"></param>
        /// <param name="overwriteParameterValues"></param>
        /// <returns>Returns true to continue loading the family</returns>
        public bool OnFamilyFound(bool familyInUse, ref bool overwriteParameterValues)
        {
            return true;
        }

        /// <summary>
        /// This is the method called when the shared family was found in the target document already.
        /// </summary>
        /// <param name="sharedFamily">The shared family in the current family document.</param>
        /// <param name="familyInUse">Indicates if at least one instance of the family is placed in the project or not</param>
        /// <param name="source">This is an output enum argument which indicates if the family will load from the project or the current family</param>
        /// <param name="overwriteParameterValues">This is an output boolean argument which indicates if overwrite the parameter values of existing types</param>
        /// <returns></returns>
        public bool OnSharedFamilyFound(Family sharedFamily, bool familyInUse, ref Rvt.FamilySource source, ref bool overwriteParameterValues)
        {
            return true;
        }

        #endregion
    }
}
