﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Autodesk.Revit.UI;

namespace ReadonlySharedParameters
{
    public class ReadonlySharedParameterApplication : IExternalApplication
    {
        #region IExternalApplication Members

        Result IExternalApplication.OnShutdown(UIControlledApplication application)
        {
            return Result.Succeeded;
        }

        Result IExternalApplication.OnStartup(UIControlledApplication application)
        {
            RibbonPanel panel = application.CreateRibbonPanel("Shared parameters");

            PushButtonData data = new PushButtonData("BindSP", "Bind Shared\nParameters", 
                                    this.GetType().Assembly.Location, typeof(BindNewReadonlySharedParametersToDocument).FullName);
            panel.AddItem(data);

            panel.AddSeparator();

            PushButtonData data1 = new PushButtonData("SetIds1", "Set ids: GUID",
                                    this.GetType().Assembly.Location, typeof(SetReadonlyId1).FullName);

            PushButtonData data2 = new PushButtonData("SetIds2", "Set ids: short",
                                    this.GetType().Assembly.Location, typeof(SetReadonlyId2).FullName);

            panel.AddStackedItems(data1, data2);

            panel.AddSeparator();

            data1 = new PushButtonData("SetCosts1", "Set cost: random",
                                    this.GetType().Assembly.Location, typeof(SetReadonlyCost1).FullName);

            data2 = new PushButtonData("SetCosts2", "Set cost: sequence",
                                    this.GetType().Assembly.Location, typeof(SetReadonlyCost2).FullName);

            panel.AddStackedItems(data1, data2);

            return Result.Succeeded;
        }

        #endregion
    }
}
