﻿// (C) Copyright 2011 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software
// in object code form for any purpose and without fee is hereby
// granted, provided that the above copyright notice appears in
// all copies and that both that copyright notice and the limited
// warranty and restricted rights notice below appear in all
// supporting documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,
// INC. DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL
// BE UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is
// subject to restrictions set forth in FAR 52.227-19 (Commercial
// Computer Software - Restricted Rights) and DFAR 252.227-7013(c)
// (1)(ii)(Rights in Technical Data and Computer Software), as
// applicable.
//

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

using Autodesk.Revit;
using System.Diagnostics;
using System.IO;
using System.Windows.Media;
using System.Windows.Forms;
using System.Windows.Media.Imaging;
using Autodesk.Revit.UI;
using Autodesk.Revit.DB;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.UI.Events;

namespace RibbonUI
{
    class Ribbon : IExternalApplication
    {

        // ExternalCommands assembly path
        static string AddInPath =
          typeof(Ribbon).Assembly.Location;

        public string mImagePath;

        #region IExternalApplication Members

        Result IExternalApplication.OnShutdown(
          UIControlledApplication application)
        {
            return Autodesk.Revit.UI.Result.Succeeded;
        }

        Result IExternalApplication.OnStartup(
          UIControlledApplication application)
        {
            try
            {
                // Create a Ribbon panel which contains  three 
                // single push buttons

                string newTabName = "Revit2015NewSamples";
                application.CreateRibbonTab(newTabName);

                    string dir = Path.GetDirectoryName(
                        System.Reflection.Assembly.GetAssembly(this.GetType()).Location);
                    string dir2 = Path.GetDirectoryName(dir);  
                  
                    mImagePath = Path.GetDirectoryName(dir2);  


                string firstPanelName = "Revision";
                RibbonPanel panel = application.CreateRibbonPanel(newTabName,
                  firstPanelName);

                // Set the information about the command we will 
                // be assigning to the button 

                PushButtonData pushButtonData = new PushButtonData(
                  "QuickRevisionSetting",
                  "Revision cloud Setting",
                  AddInPath,
                  "QuickRevisionCloud.RevisionCloudSetting");

                //' add a button to the panel 

                PushButton pushButton = panel.AddItem(pushButtonData)
                  as PushButton;

                //' add an icon 

                pushButton.LargeImage = GetBitmapImage(
                "RevisionCloudSetting.png");

                // add a tooltip 
                pushButton.ToolTip =
                  "The setting of the quick cloud revision command";

                // long description

                pushButton.LongDescription =
                    "Before run create revision cloud for picked element, \r\n" +
                     "run this command to change the settings for the revision cloud that \r\n" +
                     "will be created by creating revision cloud command.\r\n ";



                PushButtonData pushButtonData1 = new PushButtonData(
                  "CreateRevisionCloud",
                  "Revision Cloud for element",
                  AddInPath,
                  "QuickRevisionCloud.CreateRevisionCloud");

                //' add a button to the panel 

                PushButton pushButton1 = panel.AddItem(pushButtonData1)
                  as PushButton;

                //' add an icon 

                pushButton1.LargeImage = GetBitmapImage(
                "CloudRevision.png");

                // add a tooltip 
                pushButton1.ToolTip =
                  "This command can add  revision cloud for picked elements. ";

                // long description

                pushButton1.LongDescription =
                    "The revision cloud bound the picked element, \r\n" +
                     "It creates a revision object first.  \r\n" +
                     "It assign the revision setting defined by the revision setting command.\r\n ";


                string secondPanelName = "Prompt Placement Option";
                RibbonPanel panel2 = application.CreateRibbonPanel(newTabName,
                  secondPanelName);

                // Set the information about the command we will 
                // be assigning to the button 

                pushButtonData = new PushButtonData(
                  "PlacementTerminal",
                  "Place not on duct",
                  AddInPath,
                  "PromptPlacementOption.PlacementAirTerminal_NotOnDuct");

                //' add a button to the panel 

                pushButton = panel2.AddItem(pushButtonData)
                  as PushButton;

                //' add an icon 

                pushButton.LargeImage = GetBitmapImage(
                "OffDuct.png");

                // add a tooltip 
                pushButton.ToolTip =
                  "Prompt place air terminal off duct, without using the option of on duct";

                // long description

                pushButton.LongDescription =
                    "This command prompt the users to place air terminal not on duct";


                pushButtonData = new PushButtonData(
                 "PlacementTerminalOnDuct",
                 "Place terminal on duct",
                 AddInPath,
                 "PromptPlacementOption.PlacementAirTerminalOnDuct");

                //' add a button to the panel 

                pushButton = panel2.AddItem(pushButtonData)
                  as PushButton;

                //' add an icon 

                pushButton.LargeImage = GetBitmapImage(
                "PlaceOnDuct.png");

                // add a tooltip 
                pushButton.ToolTip =
                  "Prompt place air terminal on duct, it uses the API's new prompt placement option";

                // long description

                pushButton.LongDescription =
                    "This command prompt the users to place air terminal on duct";


                return Autodesk.Revit.UI.Result.Succeeded;
            }
            catch (Exception ex)
            {
                System.Windows.Forms.MessageBox.Show(ex.ToString(), "Level Generator Ribbon");
                return Autodesk.Revit.UI.Result.Failed;
            }
        }

        BitmapSource convertFromBitmap(System.Drawing.Bitmap bitmap)
        {
            return System.Windows.Interop.Imaging.CreateBitmapSourceFromHBitmap(
                bitmap.GetHbitmap(),
                IntPtr.Zero,
                Int32Rect.Empty,
                BitmapSizeOptions.FromEmptyOptions());
        }

        private BitmapImage GetBitmapImage(string imageName)
        {
            return new BitmapImage(new Uri(
              Path.Combine(mImagePath, imageName)));
        }


        /// <summary>
        /// Load the bitmap from resource. The resource image 
        /// 'Build action' must be set to 'Embeded resource'.
        /// PNG extension supports transparency.
        /// </summary>
        /// <param name="imageResourceName">Resource name .PNG</param>
        /// <returns>The loaded image</returns>
        private static System.Windows.Media.ImageSource
          LoadPNGImageFromResource(string imageResourceName)
        {
            System.Reflection.Assembly dotNetAssembly =
              System.Reflection.Assembly.GetExecutingAssembly();
            System.IO.Stream iconStream =
              dotNetAssembly.GetManifestResourceStream(imageResourceName);
            System.Windows.Media.Imaging.PngBitmapDecoder bitmapDecoder =
              new System.Windows.Media.Imaging.PngBitmapDecoder(iconStream,
                System.Windows.Media.Imaging.BitmapCreateOptions.
                PreservePixelFormat, System.Windows.Media.Imaging.
                BitmapCacheOption.Default);
            System.Windows.Media.ImageSource imageSource =
              bitmapDecoder.Frames[0];
            return imageSource;
        }


        #endregion
    }
}
