﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.DB;
using System.Timers;
using Autodesk.Revit.UI.Events;
using System.Windows.Media.Imaging;
using System.Windows;

using Autodesk.Revit;
using System.Net;

namespace GetSetElementTypes
{
   public class Application : IExternalApplication
   {
      #region IExternalApplication Members

      public Result OnShutdown(UIControlledApplication application)
      {
         return Result.Succeeded;
      }

      public Result OnStartup(UIControlledApplication application)
      {
         _defaultTypesPane = new TestGetSetDefaultFamilyTypes();
         application.RegisterDockablePane(TestGetSetDefaultFamilyTypes.PaneId, "Default Family Types", _defaultTypesPane);
         application.ViewActivated += new EventHandler<ViewActivatedEventArgs>(application_ViewActivated);


         return Result.Succeeded;
      }

      #endregion

      TestGetSetDefaultFamilyTypes _defaultTypesPane;


      void application_ViewActivated(object sender, Autodesk.Revit.UI.Events.ViewActivatedEventArgs e)
      {
         if (!DockablePane.PaneExists(TestGetSetDefaultFamilyTypes.PaneId))
            return;

         UIApplication uiApp = sender as UIApplication;
         if (uiApp == null)
            return;

         DockablePane pane = uiApp.GetDockablePane(TestGetSetDefaultFamilyTypes.PaneId);
         pane.Show();

         if (_defaultTypesPane == null)
            return;
         _defaultTypesPane.SetDocument(e.Document);
      }

   }
}
