using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;


using Autodesk.Revit.DB;
using Autodesk.Revit.UI;

namespace PromptPlacementOption
{
    //PlaceAirTerminalOnDuct = false;
    [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Manual)]
    [Autodesk.Revit.Attributes.Regeneration(Autodesk.Revit.Attributes.RegenerationOption.Manual)]
    public class PlacementAirTerminal_NotOnDuct : IExternalCommand
    {
        public Autodesk.Revit.UI.Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {
            UIDocument uiDoc = commandData.Application.ActiveUIDocument;
            Document doc = uiDoc.Document;

            //get a duct terminal symbol
            FilteredElementCollector collector = new FilteredElementCollector(doc);
            collector.OfCategory(BuiltInCategory.OST_DuctTerminal).OfClass(typeof(FamilySymbol));

            IList<Element> terminals = collector.ToElements();

            FamilySymbol sym = null;
            if (terminals.Count > 0)
                sym = terminals[0] as FamilySymbol;
            else
            {
                TaskDialog.Show("Prompt place duct terminal", "No duct terminal type in the current document");
                return Result.Failed;
            }



           
            PromptForFamilyInstancePlacementOptions promptForFamilyInstancePlacementOptions = new PromptForFamilyInstancePlacementOptions();
            promptForFamilyInstancePlacementOptions.PlaceAirTerminalOnDuct = false;
            commandData.Application.ActiveUIDocument.PromptForFamilyInstancePlacement(sym, promptForFamilyInstancePlacementOptions);
            return Result.Succeeded;
        }
    }

    //PlaceAirTerminalOnDuct = true;
    [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Manual)]
    [Autodesk.Revit.Attributes.Regeneration(Autodesk.Revit.Attributes.RegenerationOption.Manual)]
    public class PlacementAirTerminalOnDuct : IExternalCommand
    {
        public Autodesk.Revit.UI.Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {
            UIDocument uiDoc = commandData.Application.ActiveUIDocument;
            Document doc = uiDoc.Document;

            //get a duct terminal symbol
            FilteredElementCollector collector = new FilteredElementCollector(doc);
            collector.OfCategory(BuiltInCategory.OST_DuctTerminal).OfClass(typeof(FamilySymbol));

            IList<Element> terminals = collector.ToElements();

            FamilySymbol sym = null;
            if (terminals.Count > 0)
                sym = terminals[0] as FamilySymbol;
            else
            {
                TaskDialog.Show("Prompt place duct terminal", "No duct terminal type in the current document");
                return Result.Failed;
            }




            PromptForFamilyInstancePlacementOptions promptForFamilyInstancePlacementOptions = new PromptForFamilyInstancePlacementOptions();
            promptForFamilyInstancePlacementOptions.PlaceAirTerminalOnDuct = true;
            commandData.Application.ActiveUIDocument.PromptForFamilyInstancePlacement(sym, promptForFamilyInstancePlacementOptions);
            return Result.Succeeded;
        }
    }
}
