﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Autodesk.Revit.DB;

namespace STLImport
{
    class STLImportProperties
    {
        private static STLImportProperties s_properties = null;

        private STLImportProperties()
        {
            Target = TessellatedShapeBuilderTarget.AnyGeometry;
            Fallback = TessellatedShapeBuilderFallback.Mesh;
            Binary = true;
            GraphicsStyleId = ElementId.InvalidElementId;
        }

        public static STLImportProperties GetProperties()
        {
            if (s_properties == null)
            {
                s_properties = new STLImportProperties();
            }

            return s_properties;
        }

        public void SetModeToSolid()
        {
            Target = TessellatedShapeBuilderTarget.Solid;
            Fallback = TessellatedShapeBuilderFallback.Abort;
        }

        public void SetModeToAnyGeometry()
        {
            Target = TessellatedShapeBuilderTarget.AnyGeometry;
            Fallback = TessellatedShapeBuilderFallback.Mesh;
        }

        public void SetModeToPolymesh()
        {
            Target = TessellatedShapeBuilderTarget.Mesh;
            Fallback = TessellatedShapeBuilderFallback.Salvage;
        }

        public TessellatedShapeBuilderTarget Target
        {
            get;
            private set;
        }

        public TessellatedShapeBuilderFallback Fallback
        {
            get;
            private set;
        }

        public void SetGraphicsStyleToInvalid()
        {
            GraphicsStyleId = ElementId.InvalidElementId;
        }

        public void SetGraphicsStyleToSketch(Document doc)
        {
            // Find GraphicsStyle
            FilteredElementCollector collector = new FilteredElementCollector(doc);
            collector.OfClass(typeof(GraphicsStyle));

            GraphicsStyle style = collector.Cast<GraphicsStyle>().FirstOrDefault<GraphicsStyle>(gs => gs.Name.Equals("<Sketch>"));

            if (style != null)
            {
                GraphicsStyleId = style.Id;
            }
        }

        public ElementId GraphicsStyleId
        {
            get;
            private set;
        }

        public void SetModeToBinary()
        {
            Binary = true;
        }

        public void SetModelToASCII()
        {
            Binary = false;
        }

        public bool Binary
        {
            get;
            private set;
        }
    }
}
