﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Windows.Media;
using System.Drawing;
using System.IO;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using System.Diagnostics;

namespace Revit.Addin.ScheduleImages
{
   /// <summary>
   /// UI used to indicate the progress form.
   /// </summary>
   public partial class AddImageForm : System.Windows.Forms.Form
   {
      Autodesk.Revit.DB.Document m_rvtDoc;
      /// <summary>
      /// Ctor of progress indicator.
      /// </summary>
      /// <param name="formText">Form title.</param>
      /// <param name="progressMsg">Progress message.</param>
      /// <param name="progressMaximum">Maximum of the progress.</param>
      public AddImageForm(Document rvtDoc)
      {
         InitializeComponent();
         m_rvtDoc = rvtDoc;
      }

      private void buttonSingleImage_Click(object sender, EventArgs e)
      {
         openFileDialog.Multiselect = false;
         openFileDialog.FileName = AppConfig.AddonDirectory;
         DialogResult result = openFileDialog.ShowDialog();
         if (result != System.Windows.Forms.DialogResult.OK)
            return;
         List<string> imageFile = new List<string>();
         imageFile.Add(openFileDialog.FileName);
         AddImages(imageFile);
      }

      private void buttonMultiImages_Click(object sender, EventArgs e)
      {
         openFileDialog.Multiselect = true;
         openFileDialog.FileName = AppConfig.AddonDirectory;
         DialogResult result = openFileDialog.ShowDialog();
         if (result != System.Windows.Forms.DialogResult.OK)
            return;
         List<string> imageFiles = new List<string>();
         imageFiles.AddRange(openFileDialog.FileNames.ToList());
         AddImages(imageFiles);
      }

      private void buttonFolder_Click(object sender, EventArgs e)
      {
         folderBrowserDialog.SelectedPath = @"D:\Revit\Sandbox\Jim_Jia\ScheduleImages\ScheduleImages\Images";
         DialogResult rtn = folderBrowserDialog.ShowDialog();
         if (rtn != DialogResult.OK)
            return;
         string strExtFilter = ".bmp;.jpg;.jpeg;.png;.tif";
         DirectoryInfo di = new DirectoryInfo(folderBrowserDialog.SelectedPath);
         FileInfo [] files = di.GetFiles("*.*", SearchOption.TopDirectoryOnly);
         List<string> imgFiles = new List<string>();
         foreach (FileInfo fi in files)
         {
            if (strExtFilter.Contains(fi.Extension.ToLower()))
               imgFiles.Add(fi.FullName);
         }
         AddImages(imgFiles);
      }

      private void AddImages(List<string> images)
      {
         Transaction tran = new Transaction(m_rvtDoc);
         tran.Start("Add Image");
         try
         {
            int okImages = 0;
            foreach (string imagePath in images)
            {
               if (!File.Exists(imagePath))
                  continue;
               ImageType.Create(m_rvtDoc, imagePath);
               okImages++;
            }
            tran.Commit();
            string msg = string.Format("Succeed to reload {0} images.", okImages);
            MessageBox.Show(msg, "Add Images", MessageBoxButtons.OK, MessageBoxIcon.Information);
         }
         catch (Exception ex)
         {
            tran.RollBack();
            MessageBox.Show("Failed to add image(s): " + ex.ToString());
         }
      }
   }
}
