﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;
using System.Windows.Forms;
using System.Windows.Media.Imaging;

using Autodesk.Revit.UI;
using Autodesk.Revit.Attributes;

using Res = Revit.Addin.ScheduleImages.Resources;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;

namespace Revit.Addin.ScheduleImages
{
   [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Manual)]
   [Autodesk.Revit.Attributes.Regeneration(Autodesk.Revit.Attributes.RegenerationOption.Manual)]
   [Autodesk.Revit.Attributes.Journaling(Autodesk.Revit.Attributes.JournalingMode.NoCommandData)]
   public class Applicaiton : IExternalApplication
   {
      public Autodesk.Revit.UI.Result OnStartup(UIControlledApplication application)
      {
         try
         {
            #region Ribbon Items
            // create ribbon tab firstly
            string tabName = "Schedule Images";
            application.CreateRibbonTab(tabName);
            //
            // create customer Ribbon Items
            string panelName = "Parameters";
            RibbonPanel ribbonPanel = application.CreateRibbonPanel(tabName, panelName);
            PushButton cmdButton = (PushButton)ribbonPanel.AddItem(new PushButtonData("AddParametersCommand",
                Res.String_AddParameters, AppConfig.AddonAssembly, "Revit.Addin.ScheduleImages.AddParametersCommand"));
            cmdButton.Image = Utils.convertFromBitmap(Res.AddParameter.ToBitmap());
            cmdButton.LargeImage = Utils.convertFromBitmap(Res.AddParameter.ToBitmap());
            cmdButton.ToolTip = Res.String_AddParametersDescription;
            //
            // Images
            panelName = "Images";
            ribbonPanel = application.CreateRibbonPanel(tabName, panelName);
            // add image
            cmdButton = (PushButton)ribbonPanel.AddItem(new PushButtonData("AddImageCommand",
                Res.String_AddImages, AppConfig.AddonAssembly, "Revit.Addin.ScheduleImages.AddImageCommand"));
            cmdButton.Image = Utils.convertFromBitmap(Res.AddImages.ToBitmap());
            cmdButton.LargeImage = Utils.convertFromBitmap(Res.AddImages.ToBitmap());
            cmdButton.ToolTip = Res.String_AddImagesDescription;
            // reload image
            cmdButton = (PushButton)ribbonPanel.AddItem(new PushButtonData("ReloadImageCommand",
                Res.String_ReloadImage, AppConfig.AddonAssembly, "Revit.Addin.ScheduleImages.ReloadImageCommand"));
            cmdButton.Image = Utils.convertFromBitmap(Res.ReloadImages.ToBitmap());
            cmdButton.LargeImage = Utils.convertFromBitmap(Res.ReloadImages.ToBitmap());
            cmdButton.ToolTip = Res.String_ReloadDescription;
            // unload all
            cmdButton = (PushButton)ribbonPanel.AddItem(new PushButtonData("DeleteAllImagesCommand",
                Res.String_DeleteImage, AppConfig.AddonAssembly, "Revit.Addin.ScheduleImages.DeleteAllImagesCommand"));
            cmdButton.Image = Utils.convertFromBitmap(Res.DeleteImages.ToBitmap());
            cmdButton.LargeImage = Utils.convertFromBitmap(Res.DeleteImages.ToBitmap());
            cmdButton.ToolTip = Res.String_DeleteImageDescription;
            //
            // schedule
            panelName = "Schedule";
            ribbonPanel = application.CreateRibbonPanel(tabName, panelName);
            cmdButton = (PushButton)ribbonPanel.AddItem(new PushButtonData("ScheduleThumbnailCommand",
                Res.String_ScheduleThumbnail, AppConfig.AddonAssembly, "Revit.Addin.ScheduleImages.ScheduleThumbnailCommand"));
            cmdButton.Image = Utils.convertFromBitmap(Res.ScheduleThumbnail.ToBitmap());
            cmdButton.LargeImage = Utils.convertFromBitmap(Res.ScheduleThumbnail.ToBitmap());
            cmdButton.ToolTip = Res.String_ScheduleThumbnailDescription;
            //
            // restore
            cmdButton = (PushButton)ribbonPanel.AddItem(new PushButtonData("RestoreSchedulesCommand",
                Res.String_RestoreSize, AppConfig.AddonAssembly, "Revit.Addin.ScheduleImages.RestoreSchedulesCommand"));
            cmdButton.Image = Utils.convertFromBitmap(Res.RestoreSize.ToBitmap());
            cmdButton.LargeImage = Utils.convertFromBitmap(Res.RestoreSize.ToBitmap());
            cmdButton.ToolTip = Res.String_RestoreSizeDescription;
            //
            // Settings
            panelName = "Settings";
            ribbonPanel = application.CreateRibbonPanel(tabName, panelName);
            cmdButton = (PushButton)ribbonPanel.AddItem(new PushButtonData("SettingsCommand",
                Res.String_Settings, AppConfig.AddonAssembly, "Revit.Addin.ScheduleImages.SettingsCommand"));
            cmdButton.Image = Utils.convertFromBitmap(Res.Settings.ToBitmap());
            cmdButton.LargeImage = Utils.convertFromBitmap(Res.Settings.ToBitmap());
            cmdButton.ToolTip = Res.String_SettingDescription;          
            #endregion

            #region Updater
            //RebarShapeChangeUpdater rebarShapeMonitor = new RebarShapeChangeUpdater(application.ActiveAddInId);
            //if (!UpdaterRegistry.IsUpdaterRegistered(rebarShapeMonitor.GetUpdaterId()))
            //{
            //   UpdaterRegistry.RegisterUpdater(rebarShapeMonitor);
            //}
            //ElementClassFilter rebarFilter = new ElementClassFilter(typeof(Rebar));
            //UpdaterRegistry.AddTrigger(rebarShapeMonitor.GetUpdaterId(), rebarFilter,
            //    Element.GetChangeTypeParameter(new ElementId(BuiltInParameter.REBAR_SHAPE))); // monitor rebar shape change
            #endregion

            #region Events
            application.ControlledApplication.DocumentOpened += ControlledApplication_DocumentOpened;
            #endregion

            return Autodesk.Revit.UI.Result.Succeeded;
         }
         catch (Exception ex)
         {
            MessageBox.Show("Failed to create Ribbon tab and panel, you need to manually load the external command. ex:" + ex.ToString());
            return Autodesk.Revit.UI.Result.Failed;
         }
      }

      void ControlledApplication_DocumentOpened(object sender, Autodesk.Revit.DB.Events.DocumentOpenedEventArgs e)
      {
         Config config = Config.Load();
         if (!config.AutoReloadImage)
            return;

         //DialogResult result = MessageBox.Show("Revit is trying to auto reload all images, continue?", "Continue", MessageBoxButtons.OKCancel, MessageBoxIcon.Question);
         //if (result != DialogResult.OK)
         //   return;

         Utils.ReloadImages(e.Document);
      }

      public Autodesk.Revit.UI.Result OnShutdown(UIControlledApplication application)
      {
         return Autodesk.Revit.UI.Result.Succeeded;
      }
   }

   /// <summary>
   /// Application config utility used to load and save setting. 
   /// </summary>
   public sealed class AppConfig
   {
      #region Member Properties
      /// <summary>
      /// The addin directory
      /// </summary>
      public static string AppName = "Schedule Images";

      /// <summary>
      /// The addin directory
      /// </summary>
      public static string AddonDirectory
      {
         get { return Path.GetDirectoryName(typeof(AppConfig).Assembly.Location); }
      }

      public static string AddonAssembly
      {
         get { return typeof(AppConfig).Assembly.Location; }
      }
      #endregion
   }
}


