﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Windows.Media;
using System.Drawing;

namespace Revit.Addin.ScheduleImages
{
    /// <summary>
    /// UI used to indicate the progress form.
    /// </summary>
    public partial class ProgressForm : System.Windows.Forms.Form
    {
        /// <summary>
        /// Ctor of progress indicator.
        /// </summary>
        /// <param name="formText">Form title.</param>
        /// <param name="progressMsg">Progress message.</param>
        /// <param name="progressMaximum">Maximum of the progress.</param>
        public ProgressForm(string formText, string progressMsg, int progressMaximum)
        {
            InitializeComponent();
            this.Text = formText;
            progressLabel.Text = progressMsg;
            progressBar.Minimum = 0;
            progressBar.Maximum = progressMaximum;
            progressBar.Value = 0;
            progressBar.Step = 1;
            Thread.Sleep(50);
        }

        /// <summary>
        /// Performs one step for progress bar.
        /// </summary>
        public void performProgressBarSteps(string progessMsg = null)
        {
            progressBar.PerformStep();
            if (!string.IsNullOrEmpty(progessMsg))
            {
                progressLabel.Text = progessMsg;
            }
            this.Refresh();
        }

        public void setProgressText(string labelString)
        {
            progressLabel.Text = labelString;
            this.Refresh();
        }

        private void ProgressForm_Load(object sender, EventArgs e)
        {
            System.Windows.Forms.Form ownerFrm = this.Owner as System.Windows.Forms.Form;
            if (null != ownerFrm)
            {
               System.Drawing.Point location = this.Owner.Location;
               location.X += (int)((ownerFrm.Size.Width - this.Size.Width) * 0.5);
               location.Y += (int)(ownerFrm.Size.Height * 0.5);
               this.Location = location;
            }
            else
               this.Location = new Point(400, 300);
        }
    }
}
