﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Windows.Media;
using System.Drawing;
using System.IO;
using System.Configuration;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Architecture;
using System.Diagnostics;
using System.Reflection;

namespace Revit.Addin.ScheduleImages
{
   /// <summary>
   /// UI used to indicate the progress form.
   /// </summary>
   public partial class SettingForm : System.Windows.Forms.Form
   {
      Document m_rvtDoc;

      public SettingForm(Document rvtDoc)
      {
         InitializeComponent();
         m_rvtDoc = rvtDoc;

         Config config = Config.Load();
         checkBoxAutoReload.Checked = config.AutoReloadImage;
         checkBoxDMU.Checked = config.RealtimeUpdateImage;
      }

      private void buttonOK_Click(object sender, EventArgs e)
      {
         Config config = Config.Load();
         config.AutoReloadImage = checkBoxAutoReload.Checked;
         config.RealtimeUpdateImage = checkBoxDMU.Checked;
         config.Save();
      }

      private void button1_Click(object sender, EventArgs e)
      {
      }

      private void checkBoxAutoReload_CheckedChanged(object sender, EventArgs e)
      {
         if (checkBoxAutoReload.Checked)
         {
            MessageBox.Show("The auto reload will take effect for next document penning.");
         }
      }
   }
}
