﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media.Imaging;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.Structure;

namespace Revit.Addin.ScheduleImages
{
      public class RebarShapeChangeUpdater : IUpdater, IDisposable
      {
         AddInId m_appId;
         UpdaterId m_updaterId;

         public RebarShapeChangeUpdater(AddInId id)
         {
            m_appId = id;
            m_updaterId = new UpdaterId(m_appId, new Guid("B58FC23C-428E-48F9-9F08-06FB044A3793"));
         }

         public void Dispose()
         {
            m_appId.Dispose();
            m_updaterId.Dispose();
         }

         public void Execute(UpdaterData data)
         {
            Document document = data.GetDocument();
            ICollection<ElementId> modifiedElemIds = data.GetModifiedElementIds();
            foreach (ElementId elemId in modifiedElemIds)
            {
               Rebar rebar = document.GetElement(elemId) as Rebar;
               if (rebar == null)
                  continue;
               
               Parameter paramTypeMark = rebar.get_Parameter(BuiltInParameter.REBAR_SHAPE);
            }
         }

         public string GetAdditionalInformation()
         {
            return "Rebar shape updater: Update Rebar bar image on rebar shape change.";
         }

         public ChangePriority GetChangePriority()
         {
            return ChangePriority.Rebar;
         }

         public UpdaterId GetUpdaterId()
         {
            return m_updaterId;
         }

         public string GetUpdaterName()
         {
            return "Rebar Shape Updater";
         }
      }
}
