﻿Imports System
Imports System.Collections.Generic
Imports Autodesk.Revit
Imports Autodesk.Revit.Elements
Imports CmdResult = Autodesk.Revit.IExternalCommand.Result

Public Class Command
    Implements IExternalCommand

    Public Function Execute( _
        ByVal commandData As ExternalCommandData, _
        ByRef message As String, _
        ByVal elements As ElementSet) _
        As CmdResult _
        Implements IExternalCommand.Execute

        Dim app As Application = commandData.Application
        Dim doc As Document = app.ActiveDocument

        Dim opt As VolumeCalculationOptions _
            = doc.Settings.VolumeCalculationSetting _
                .VolumeCalculationOptions

        opt.VolumeComputationEnable = True

        opt.RoomAreaBoundaryLocation _
            = Rooms.BoundaryLocationType.WallCenter

        doc.Settings.VolumeCalculationSetting _
            .VolumeCalculationOptions = opt

        Dim volumes As List(Of String) = New List(Of String)
        Dim els As ElementSet = doc.Selection.Elements

        Dim e As Autodesk.Revit.Element
        For Each e In els
            If TypeOf e Is Room Then
                Dim room As Room = CType(e, Room)
                volumes.Add(room.Volume.ToString("0.##"))
                'Else
                '    volumes.Add("Not a room")
            End If
        Next

        If 0 = volumes.Count Then
            message = "Please select some rooms."
        Else
            Dim s As String = _
                +"Selected room volumes in cubic feet: " _
                + String.Join(", ", volumes.ToArray()) _
                + "."
            MsgBox(s)
        End If

        Return CmdResult.Failed
    End Function
End Class
