﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Http;

namespace RoomPolygon.Controllers
{
  class Level
  {
    public string Name { get; set; }
    public double Elevation { get; set; }

    public Level( string name, double elevation )
    {
      Name = name;
      Elevation = elevation;
    }

    public override string ToString()
    {
      return Name + ", " 
        + Elevation.ToString( "0.###" );
    }
  }

  public class LevelsController : ApiController
  {
    static List<Level> _levels = new List<Level>()
    {
      new Level ( "Level 1", 12.345 ),
      new Level ( "Level 2", 67.89 )
    };

    // GET api/levels
    public IEnumerable<string> Get()
    {
      return new string[] { 
        "1: Level 1, 12.345", 
        "2: Level 2, 67.89" };
    }

    public string Get( string id )
    {
      if( id.ToLower().Equals( "all" ) )
      {
        return Get().Aggregate<string>( 
          ( current, next ) 
            => current + ", " + next );
      }
      try
      {
        int i = int.Parse( id );
        if( 0 > i )
        {
          return string.Format( 
            "Invalid negative level id '{0}'", 
            id );
        }
        if( _levels.Count <= i )
        {
          return string.Format( 
            "Invalid out-of-range level id '{0}'", 
            id );
        }
        return _levels[i].ToString();
      }
      catch( Exception ex )
      {
        return string.Format( 
          "Invalid level id '{0}': {1}", 
          id, ex.Message );
      }
    }

    // POST api/levels
    public void Post( [FromBody]string value )
    {
    }

    // PUT api/levels/5
    public void Put( int id, [FromBody]string value )
    {
    }

    // DELETE api/levels/5
    public void Delete( int id )
    {
    }
  }
}
