#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using System.Diagnostics;
#endregion

namespace RunningLanguage
{
  class App : IExternalApplication
  {
    string LanguageCode( LanguageType lt )
    {
      switch( lt )
      {
        case LanguageType.Chinese_Simplified:
          return "CHS";

        case LanguageType.Chinese_Traditional:
          return "CHT";

        case LanguageType.Czech:
          return "CSY";

        case LanguageType.German:
          return "DEU";

        case LanguageType.English_USA:
          return "ENU";

        case LanguageType.Spanish:
          return "ESP";

        case LanguageType.French:
          return "FRA";

        case LanguageType.Hungarian:
          return "HUN";

        case LanguageType.Italian:
          return "ITA";

        case LanguageType.Japanese:
          return "JPN";

        case LanguageType.Korean:
          return "KOR";

        case LanguageType.Polish:
          return "PLK";

        case LanguageType.Brazilian_Portuguese:
          return "PTB";

        case LanguageType.Russian:
          return "RUS";

        case LanguageType.Dutch:
          return "NLD";
      }
      return null;
    }

    public Result OnStartup( 
      UIControlledApplication a )
    {
      LanguageType lt 
        = a.ControlledApplication.Language;

      string language_code = LanguageCode( lt );

      Debug.Print( "Revit language code is " 
        + language_code + "." );

      return Result.Succeeded;
    }

    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }
  }
}
