#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using System.Reflection;
#endregion

namespace RvtLaunchExe
{
  class App : IExternalApplication
  {
    /// <summary>
    /// Add our command button to the ribbon panel.
    /// </summary>
    void PopulatePanel( RibbonPanel p )
    {
      string path = Assembly.GetExecutingAssembly()
        .Location;

      RibbonItemData rid = new PushButtonData(
          "RvtLaunchExe_Command", 
          "Launch External\r\nWindows Executable",
          path, "RvtLaunchExe.Command" );

      rid.ToolTip = "Launch an external "
        + " stand-alone Windows executable";

      p.AddItem( rid );
    }

    public Result OnStartup( UIControlledApplication a )
    {
      PopulatePanel(
        a.CreateRibbonPanel(
          "Launch Executable" ) );

      return Result.Succeeded;
    }

    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }
  }
}
