#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System.IO;
#endregion

namespace RvtLaunchExe
{
  [Transaction( TransactionMode.ReadOnly )]
  public class Command : IExternalCommand
  {
    const string _standalone_exe_path
      = "C:/a/vs/RvtLaunchExe/SampleExe/bin/Debug/SampleExe.exe";

    int LaunchExe( string path )
    {
      if( !File.Exists( path ) )
      {
        throw ( new ArgumentException( string.Format( 
          "'{0}' not found.", path ) ) );
      }

      int rc = 0;

      // Prepare the process to run

      ProcessStartInfo start = new ProcessStartInfo();
      
      // Enter the command line arguments, everything 
      // you would enter after the executable name.

      //start.Arguments = arguments;

      // Enter the complete executable path

      start.FileName = path;

      // Do you want to show a console window?

      start.WindowStyle = ProcessWindowStyle.Hidden;
      start.CreateNoWindow = true;

      // Run the external process and 
      // wait for it to finish

      using( Process proc = Process.Start( start ) )
      {
        proc.WaitForExit();

        // Retrieve the app's exit code

        rc = proc.ExitCode;
      }
      return rc;
    }

    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      int rc = LaunchExe( _standalone_exe_path );

      if( 0 != rc )
      {
        message = string.Format( 
          "{0} returned error code {1}",
          _standalone_exe_path, rc );

        return Result.Failed;
      }

      return Result.Succeeded;
    }
  }
}
