
//
// (C) Copyright 2006 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using Autodesk.Revit;

namespace RvtMgdDbg {
    public class App : IExternalApplication {

            // get the absolute path of this assembly
        static string ExecutingAssemblyPath = System.Reflection.Assembly.GetExecutingAssembly().Location;
        private AppDocEvents m_appDocEvents;

        public IExternalApplication.Result
        OnStartup(ControlledApplication application)
        {
            //MessageBox.Show("IExternalApplication.OnStartup()");

            AddMenu(application);           
            AddAppDocEvents(application);

            return IExternalApplication.Result.Succeeded;
        }

        public IExternalApplication.Result
        OnShutdown(ControlledApplication application)
        {
            //MessageBox.Show("IExternalApplication.OnShutdown()");
            RemoveAppDocEvents();

            return IExternalApplication.Result.Succeeded;
        }

        private void
        AddMenu(ControlledApplication app)
        {
            Autodesk.Revit.RibbonPanel rvtRibbonPanel = app.CreateRibbonPanel("RvtMgdDbg");

            PushButtonData snoopDb    = new PushButtonData("SnoopDb", "Snoop Db...", ExecutingAssemblyPath, "RvtMgdDbg.CmdSnoopDb");
            PushButtonData snoopCur   = new PushButtonData("SnoopCurrent", "Snoop Current Selection...", ExecutingAssemblyPath, "RvtMgdDbg.CmdSnoopModScope");
            PushButtonData snoopApp   = new PushButtonData("SnoopApp", "Snoop Application...", ExecutingAssemblyPath, "RvtMgdDbg.CmdSnoopApp");
            PushButtonData tests      = new PushButtonData("Tests", "Test Framework...", ExecutingAssemblyPath, "RvtMgdDbg.CmdTestShell");
            PushButtonData events     = new PushButtonData("Events", "Events...", ExecutingAssemblyPath, "RvtMgdDbg.CmdSnoopApp");                      
            
            snoopDb.Image  = LoadBitmap(global::RvtMgdDbg.Properties.Resources.Snoop);
            snoopCur.Image = LoadBitmap(global::RvtMgdDbg.Properties.Resources.Snoop);
            snoopApp.Image = LoadBitmap(global::RvtMgdDbg.Properties.Resources.Snoop);
            tests.Image    = LoadBitmap(global::RvtMgdDbg.Properties.Resources.Tests);
            events.Image   = LoadBitmap(global::RvtMgdDbg.Properties.Resources.Events); 

            rvtRibbonPanel.AddStackedButtons(snoopDb, snoopCur, snoopApp);            
            rvtRibbonPanel.AddSeparator();
            rvtRibbonPanel.AddStackedButtons(tests, events);                    
        }        

        private void
        AddAppDocEvents(ControlledApplication app)
        {
            m_appDocEvents = new AppDocEvents(app);
            m_appDocEvents.EnableEvents();
        }

        private void
        RemoveAppDocEvents()
        {
            m_appDocEvents.DisableEvents();
        }

        private System.Windows.Media.Imaging.BitmapSource
        LoadBitmap(System.Drawing.Bitmap source)
        {
            return System.Windows.Interop.Imaging.CreateBitmapSourceFromHBitmap(source.GetHbitmap(), IntPtr.Zero, System.Windows.Int32Rect.Empty,
                System.Windows.Media.Imaging.BitmapSizeOptions.FromEmptyOptions());
        }
    }
}
