
//
// (C) Copyright 2006 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using Revit = Autodesk.Revit;
using Autodesk.Revit.Geometry;
using RvtMgdDbg.Graphics;


namespace RvtMgdDbg.Test {

    class TestGeometry : RvtMgdDbgTestFuncs {

        public
        TestGeometry(Autodesk.Revit.Application app)
            : base(app)
        {
            m_testFuncs.Add(new RvtMgdDbgTestFuncInfo("Ellipse", "Hardwire a simple Ellipse", typeof(Revit.Elements.ModelEllipse), new RvtMgdDbgTestFuncInfo.TestFunc(EllipseHardwire), RvtMgdDbgTestFuncInfo.TestType.Create));
            m_testFuncs.Add(new RvtMgdDbgTestFuncInfo("Elliptical Arc", "Hardwire a simple Elliptical Arc", typeof(Revit.Elements.ModelEllipse), new RvtMgdDbgTestFuncInfo.TestFunc(EllipticalArcHardwire), RvtMgdDbgTestFuncInfo.TestType.Create));
            m_testFuncs.Add(new RvtMgdDbgTestFuncInfo("Create Helix", "Create Helix with Model Curves", typeof(Revit.Elements.ModelCurve), new RvtMgdDbgTestFuncInfo.TestFunc(CreateHelix), RvtMgdDbgTestFuncInfo.TestType.Create));
            m_testFuncs.Add(new RvtMgdDbgTestFuncInfo("Build Tower", "Build Tower with Model Curves", typeof(Revit.Elements.ModelCurve), new RvtMgdDbgTestFuncInfo.TestFunc(BuildTower), RvtMgdDbgTestFuncInfo.TestType.Create));
        }


        public void
        CreateHelix()
        {
            double increment = 0.1;
            double current = 0;
            Revit.Geometry.XYZ startPt;
            Revit.Geometry.XYZ endPt;
            Revit.Geometry.XYZ zAxis = GeomUtils.kZAxis;
            Revit.Geometry.XYZ origin = GeomUtils.kOrigin;
            Revit.Geometry.Line line;
            Revit.Geometry.Plane plane = m_revitApp.Create.NewPlane(zAxis, origin);
            Revit.Elements.SketchPlane sketchPlane = m_revitApp.ActiveDocument.Create.NewSketchPlane(plane);
            Revit.Geometry.CurveArray curveArray = new CurveArray();

            startPt = new XYZ(Math.Cos(current), Math.Sin(current), current);
            current += increment;

            while (current <= GeomUtils.kTwoPi) {
                endPt = new XYZ(Math.Cos(current), Math.Sin(current), current);

                line = m_revitApp.Create.NewLine(startPt, endPt, true);
                curveArray.Append(line);

                startPt = endPt;
                current += increment;
            }

            m_revitApp.ActiveDocument.Create.NewModelCurveArray(curveArray, sketchPlane);
        }

        public void
        BuildTower()
        {
            if (m_revitApp.ActiveDocument.BeginTransaction()) {
                Tower tower = new Tower(m_revitApp);
                tower.Build();

                m_revitApp.ActiveDocument.EndTransaction();
            }
        }

        public void
        EllipseHardwire()
        {
                // Revit PI   = 3.14159265358979
                // AutoCAD PI = 3.14159265358979323846;
                // Math.Pi    = 3.14159265358979323846;
            double revitPi = 3.14159265358979;  // TBD: have to use Revit's version of Pi or the Ellipse will fail!

                // make a simple Ellipse, oriented in the Y axis, at the origin.
            double radiusX = 5.0;
            double radiusY = 8.0;
            Revit.Elements.SketchPlane sketchPlane = Utils.Geometry.GetWorldPlane(m_revitApp);
                // TBD: in order to get a full ellipse, I have to know the exact full parameter range (see above).  Should just be two signatures.
            Ellipse ellipse = m_revitApp.Create.NewEllipse(GeomUtils.kOrigin, radiusX, radiusY, GeomUtils.kXAxis, GeomUtils.kYAxis, 0.0, (revitPi*2.0));

            m_revitApp.ActiveDocument.Create.NewModelCurve(ellipse, sketchPlane);
        }

        public void
        EllipticalArcHardwire()
        {
            double revitPi = 3.14159265358979;  // TBD: see above

                // make a simple Ellipse, oriented in the X axis, at the origin.
            double radiusX = 8.0;
            double radiusY = 5.0;
            Revit.Elements.SketchPlane sketchPlane = Utils.Geometry.GetWorldPlane(m_revitApp);
                // TBD: in order to get a full ellipse, I have to know the exact full parameter range (see above).  Should just be two signatures.
            Ellipse ellipse = m_revitApp.Create.NewEllipse(GeomUtils.kOrigin, radiusX, radiusY, GeomUtils.kXAxis, GeomUtils.kYAxis, 0.0, (revitPi*1.5));

            m_revitApp.ActiveDocument.Create.NewModelCurve(ellipse, sketchPlane);
        }
    }
}
