using System;
using System.Collections.Generic;
using System.Text;

using Autodesk.Revit;
using Autodesk.Revit.Elements;
using Autodesk.Revit.Collections;
using Autodesk.Revit.Symbols;
using Autodesk.Revit.Geometry;

namespace RvtMgdDbg.Utils
{
    class View
    {      
        /// <summary>
        /// Finds all the views in the active document.
        /// </summary>
        /// <param name="doc">the active document</param>
        public static ViewSet
        GetAllViews (Document doc)
        {
            ViewSet allViews = new ViewSet();

            ElementIterator iter = doc.Elements;
            while (iter.MoveNext())
            {
                Autodesk.Revit.Elements.View view = iter.Current as Autodesk.Revit.Elements.View;

                if (null == view)
                {
                    continue;
                }
                else
                {
                    Symbol objType = view.ObjectType;
                    if (null == objType || objType.Name.Equals("Drawing Sheet"))
                    {
                        continue;
                    }
                    else
                    {
                        allViews.Insert(view);
                    }
                }
            }
            return allViews;
        }


        /// <summary>
        /// Gather up all the available sheets.
        /// </summary>
        /// <param name="doc"></param>
        /// <param name="sheet"></param>
        /// <returns></returns>
        public static ElementSet
        GetAllSheets (Document doc)
        {
            ElementSet allSheets = new Autodesk.Revit.ElementSet();

            ElementIterator iter = doc.get_Elements(typeof(ViewSheet));
            while (iter.MoveNext())
            {
                ViewSheet viewSheet = iter.Current as ViewSheet;

                if (null == viewSheet)
                {
                    continue;
                }
                else
                {
                    Symbol objType = viewSheet.ObjectType;
                    if (null == objType)
                    {
                        continue;
                    }
                    else
                    {
                        allSheets.Insert(viewSheet);
                    }
                }
            }
            return allSheets;
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="doc"></param>
        /// <returns></returns>
        public static ViewSet
        GetAvailableViewsToExport (Document doc)
        {
            ViewSet viewSet = new ViewSet();

            // TBD: using a filter iterator will only give you the base class View, not derived classes
            // like View3D or ViewDrafting.
            /*ElementFilterIterator viewIter = m_revitApp.ActiveDocument.get_Elements(typeof(Autodesk.Revit.Elements.View));
            while (viewIter.MoveNext()) {
                Autodesk.Revit.Elements.View tmpView = (Autodesk.Revit.Elements.View)viewIter.Current;
                if (tmpView.CanBePrinted)
                    viewSet.Insert((Autodesk.Revit.Elements.View)viewIter.Current);
            }*/

            ElementIterator iter = doc.Elements;
            while (iter.MoveNext())
            {
                Autodesk.Revit.Elements.View tmpView = iter.Current as Autodesk.Revit.Elements.View;

                if ((tmpView != null) && tmpView.CanBePrinted)
                {
                    viewSet.Insert(tmpView);
                }
            }

            return viewSet;
        }
    }
}
