﻿// my apologizes, I'm a french student programmer 
// since september so my code is sometime dirty, 
// like my english, but the idea is here and the 
// code works fine.
//
// thank you for your website, I am pleased 
// to participate.
//
// V.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using Autodesk.Revit.Attributes;

namespace SelectFaceInLinkedFile
{
  [TransactionAttribute( TransactionMode.Manual )]
  public class SelectFaceInLinkedFile : IExternalCommand
  {
    public Result Execute( 
      ExternalCommandData commandData, 
      ref string message, 
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      
      PlanarFace Plan = SelectFace( uiapp );

      return Result.Succeeded;
    }

    public static PlanarFace SelectFace( 
      UIApplication uiapp )
    {
      Document doc = uiapp.ActiveUIDocument.Document;

      // get all ref doc. 

      IEnumerable<Document> doc2 
        = GetLinkedDocuments( doc );

      // get the ref of a selected plane

      Selection sel = uiapp.ActiveUIDocument.Selection;

      Reference pickedRef = sel.PickObject( 
        ObjectType.PointOnElement, 
        "Please select a Face" );

      Element elem = doc.GetElement( 
        pickedRef.ElementId );

      // get the true position picked 
      // in the active document

      XYZ pos = pickedRef.GlobalPoint;

      // get the ID of the element containing the 
      // face you picked in the active document 
      // and in its host document

      string s = pickedRef
        .ConvertToStableRepresentation( doc );

      string[] tab_str = s.Split( ':' );

      string id = tab_str[tab_str.Length - 3];

      int ID;
      Int32.TryParse( id, out ID );

      Type et = elem.GetType();

      if( typeof( RevitLinkType ) == et
        || typeof( RevitLinkInstance ) == et
        || typeof( Instance ) == et )
      {
        foreach( Document d in doc2 )
        {
          if( elem.Name.Contains( d.Title ) )
          {
            Element element = d.GetElement( 
              new ElementId( ID ) );

            Options ops = new Options();
            ops.ComputeReferences = true;
        
            // write the name of the element and the 
            // number of solids in this only for 
            // control to show the possibilities

            MessageBox.Show( element.Name, 
              element.get_Geometry( ops )
                .Objects.Size.ToString() );

            GeometryObject obj 
              = element.get_Geometry( ops )
                .Objects.get_Item( 0 );

            // test all surfaces of solids in the 
            // element and return the one containing 
            // the picked point as a planarface to 
            // build my sketchplan

            foreach( GeometryObject obj2 in 
              element.get_Geometry( ops ).Objects )
            {
              if( obj2.GetType() == typeof( Solid ) )
              {
                Solid solid2 = obj2 as Solid;
                foreach( Face face2 in solid2.Faces )
                {
                  try
                  {
                    if( face2.Project( pos )
                      .XYZPoint.DistanceTo( pos ) == 0 )
                    {
                      return face2 as PlanarFace;
                    }
                  }
                  catch( NullReferenceException )
                  {
                  }
                }
              }
            }
          }
        }
      }
      return null;
    }

    // this part is not mine, i found it on the internet, 
    // i don't anderstand all the code

    public static IEnumerable<ExternalFileReference> 
      GetLinkedFileReferences( Document _document )
    {
      var collector = new FilteredElementCollector( 
        _document );

      var linkedElements = collector
        .OfClass( typeof( RevitLinkType ) )
        .Select( x => x.GetExternalFileReference() )
        .ToList();

      return linkedElements;
    }

    public static IEnumerable<Document> 
      GetLinkedDocuments( Document _document )
    {
      var linkedfiles = GetLinkedFileReferences( 
        _document );

      var linkedFileNames = linkedfiles
        .Select( x => ModelPathUtils
          .ConvertModelPathToUserVisiblePath( 
            x.GetAbsolutePath() ) ).ToList();

      return _document.Application.Documents
        .Cast<Document>()
        .Where( doc => linkedFileNames.Any( 
          fileName => doc.PathName.Equals( fileName ) ) );
    }
  }
}
