#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
#endregion

namespace SetDetailCurveVisibility
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    class DetailCurveSelectionFilter : ISelectionFilter
    {
      public bool AllowElement( Element e )
      {
        CurveElementFilter filter
          = new CurveElementFilter(
            CurveElementType.DetailCurve );

        return filter.PassesFilter( e );
      }

      public bool AllowReference( Reference r, XYZ p )
      {
        return false;
      }
    }

    public void SetFamilyVisibility( UIDocument uidoc )
    {
      Document doc = uidoc.Document;

      Reference r = uidoc.Selection.PickObject(
        ObjectType.Element,
        new DetailCurveSelectionFilter(),
        "Select detail curve" );

      Element elem = doc.GetElement( r );

      Parameter visParam = elem.get_Parameter(
        BuiltInParameter.GEOM_VISIBILITY_PARAM );

      int vis = visParam.AsInteger();

      using( Transaction t = new Transaction( doc ) )
      {
        t.Start( "Set curve visibility" );

        // Turn off the bit corresponding
        // to the unwanted modes

        vis = vis & ~( 1 << 13 ); // Coarse
        //vis = vis & ~(1 << 14); // Medium
        //vis = vis & ~(1 << 15); // Fine

        visParam.Set( vis );

        t.Commit();
      }
    }

    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;

      try
      {
        SetFamilyVisibility( uidoc );
        return Result.Succeeded;
      }
      catch( Exception e )
      {
        TaskDialog.Show( "Exception", e.ToString() );
        return Result.Succeeded;
      }
    }
  }
}
