﻿using System;
using System.Diagnostics;
using System.IO;
using System.Runtime.Serialization.Formatters;
using System.Runtime.Serialization.Formatters.Binary;
using Autodesk.Revit;
using Autodesk.Revit.Parameters;

namespace StoreData
{
  /// <summary>
  /// Test class A.
  /// </summary>
  [Serializable()]
  public class A
  {
    public int I;
    public double D;

    public A( int i, double d )
    {
      I = i;
      D = d;
    }
  }

  /// <summary>
  /// Test class B.
  /// </summary>
  [Serializable()]
  public class B
  {
    public string S;
    public A A;

    public B( string s, int i, double d )
    {
      S = s;
      A = new A( i, d );
    }
  }

  public class Command : IExternalCommand
  {
    /// <summary>
    /// Encode arbitrary .NET serialisable object 
    /// into binary data encodes as base64 string.
    /// </summary>
    string Encode64( object obj )
    {
      // serialize into binary stream

      BinaryFormatter f = new BinaryFormatter();
      MemoryStream stream = new MemoryStream();
      f.Serialize( stream, obj );
      stream.Position = 0;

      // encode binary data to base64 string

      long n2 = stream.Length;
      Debug.Assert( n2 < int.MaxValue, "expected stream length in integer range" );
      int n = (int) n2;
      byte[] buf = new byte[n];
      stream.Read( buf, 0, n );
      return Convert.ToBase64String( buf );
    }

    /// <summary>
    /// Decode arbitrary .NET serialisable object 
    /// from binary data encoded as base64 string.
    /// </summary>
    object Decode64( string s64 )
    {
      // decode string back to binary data:

      MemoryStream s = new MemoryStream( Convert.FromBase64String( s64 ) );
      s.Position = 0;

      // deserialize:

      BinaryFormatter f = new BinaryFormatter();
      //f.AssemblyFormat = FormatterAssemblyStyle.Simple;
      // add this line to avoid the "unable to find assembly" issue:
      f.Binder = new JtLinkBinder(); 
      return f.Deserialize( s );
    }

    /// <summary>
    /// Resolve System.Runtime.Serialization.SerializationException, Message = 
    /// "Unable to find assembly 'StoreData, Version=1.0.0.0, Culture=neutral, PublicKeyToken=null'."
    /// One solution is to ensure that assembly resides in same directory as acad.exe or revit.exe,
    /// the other is to implement a class such as this, cf. 
    /// http://www.codeproject.com/soap/Serialization_Samples.asp
    /// -- Jeremy Tammik
    /// </summary>
    public sealed class JtLinkBinder 
      : System.Runtime.Serialization.SerializationBinder
    {
      public override System.Type BindToType( 
        string assemblyName, 
        string typeName )
      {
        return Type.GetType( string.Format( "{0}, {1}", 
          typeName, assemblyName ) );
      }
    }

    Parameter GetAppropriateParameter( Element e )
    {
      return null;
    }

    public IExternalCommand.Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      Application app = commandData.Application;
      Document doc = app.ActiveDocument;
      SelElementSet sel = doc.Selection.Elements;
      int count = 0;
      foreach( Element e in sel )
      {
        // determine data to store|:

        double d = ( null == e.Level ) ? 0.0 : e.Level.Elevation;
        B b = new B( e.Name, e.Id.Value, d );

        // serialise and encode data into string:

        string s64 = Encode64( b );

        // determine where to store the data:

        Parameter p = GetAppropriateParameter( e );
        if( null != p )
        {
          // write data to element parameter:

          p.Set( s64 );

          // read data from element parameter:

          s64 = p.AsString();
        }

        // decode and deserialise data back:

        B b2 = Decode64( s64 ) as B;

        ++count;
      }
      if( 0 == count )
      {
        message = "Please select one or more elements.";
      }
      return 0 == count
        ? IExternalCommand.Result.Failed
        : IExternalCommand.Result.Succeeded;
    }
  }
}
