﻿Imports System
Imports System.Windows.Forms
Imports Autodesk
Imports Autodesk.Revit
Imports Autodesk.Revit.DB
Imports Autodesk.Revit.UI
Imports SurfaceTool.BuildingCoder.Util

<Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Automatic)> _
<Autodesk.Revit.Attributes.Regeneration(Autodesk.Revit.Attributes.RegenerationOption.Manual)> _
Public Class Command

    Implements Autodesk.Revit.UI.IExternalCommand
    Dim App As UIApplication
    Dim globalcdata As ExternalCommandData

    Public Function Execute(ByVal commandData As Autodesk.Revit.UI.ExternalCommandData, ByRef message As String, ByVal elements As Autodesk.Revit.DB.ElementSet) As Autodesk.Revit.UI.Result Implements Autodesk.Revit.UI.IExternalCommand.Execute

        globalcdata = commandData



        App = commandData.Application
        Dim revit As Autodesk.Revit.UI.UIApplication = commandData.Application
        'im Sset As ElementSet = Revit.ActiveUIDocument.Selection.Elements
        Dim colection As Autodesk.Revit.DB.ElementSet = revit.ActiveUIDocument.Selection.Elements
        If colection.Size < 1 Then
            message = "Please select surface object first."
            'Return 1
        End If
        Dim flag As Boolean = True
        Try
            Dim enumerator As IEnumerator = colection.GetEnumerator
            Dim flag3 As Boolean = enumerator.MoveNext
            Dim options As DB.Options = revit.Application.Create.NewGeometryOptions
            If options IsNot Nothing Then
                options.ComputeReferences = True
                options.DetailLevel = Autodesk.Revit.DB.DetailLevels.Fine

                ' Either the DetailLevel or the View can be set, but not both
                'geomOption.View = commandData.Application.Application.ActiveDocument.ActiveView;


                'TaskDialog.Show("Revit", "Geometry Option created successfully.")
            End If

            Dim detailines As Boolean = True
            If TypeOf App.ActiveUIDocument.Document.ActiveView Is ViewPlan Then
                detailines = True
            Else
                detailines = False
            End If
            Do While flag3
                If TypeOf enumerator.Current Is DB.Element Then
                    Dim enumerator2 As IEnumerator
                    Dim current As DB.Element = DirectCast(enumerator.Current, DB.Element)
                    Dim surface As TopographySurface = DirectCast(current, TopographySurface)
                    Dim array As GeometryObjectArray = surface.Geometry(options).Objects
                    Try
                        enumerator2 = array.GetEnumerator
                        Do While enumerator2.MoveNext
                            Dim obj2 As GeometryObject = DirectCast(enumerator2.Current, GeometryObject)
                            Dim mesh As Mesh = TryCast(obj2, Mesh)
                            If (Not mesh Is Nothing) Then
                                Dim num As Integer = 0
                                Dim num2 As Integer = 0
                                Dim num3 As Integer = mesh.NumTriangles - 1 ' (mesh.get_NumTriangles - 1)
                                num = 0
                                Do While (num <= num3)
                                    num2 = 0
                                    Do
                                        Dim startpoint As DB.XYZ = mesh.Triangle(num).Vertex(num2)
                                        Dim endpoint As DB.XYZ = mesh.Triangle(num).Vertex((num2 + 1))
                                        CreateModelLine(startpoint, endpoint)
                                        'If (startpoint.DistanceTo(endpoint) > 18) Then
                                        'Me.drawline(startpoint, endpoint, detailines)
                                        ''Dim geomLine As Line = App.Application.Create.NewLine(startpoint, endpoint, True)
                                        ''Dim geomPlane As DB.PlanarFace = App.Application.Create.NewFaceArray(startpoint, endpoint)
                                        ''Dim sketch As DB.SketchPlane = App.ActiveUIDocument.Document.Create.NewSketchPlane(geomLine)
                                        ''Dim line As ModelLine = TryCast(App.ActiveUIDocument.Document.Create.NewModelCurve(geomLine, sketch), ModelLine)
                                        '   End If
                                        num2 += 1
                                    Loop While (num2 <= 1)
                                    num += 1
                                Loop
                            End If
                        Loop
                        'Finally
                    Catch ex As Exception
                        MsgBox(ex.Message)

                    End Try
                    flag3 = enumerator.MoveNext
                End If
            Loop
            flag = False
        Catch exception1 As Exception

        Finally
            If flag Then
                Interaction.MsgBox("command failed.", MsgBoxStyle.OkOnly, Nothing)
            End If
        End Try
        Return Result.Succeeded

    End Function

    'Public Sub drawline(ByVal startpoint As DB.XYZ, ByVal endpoint As DB.XYZ, ByVal Detailines As Boolean)

    '    If Detailines Then
    '        Try


    '            Dim geometryCurve As Line = App.Application.Create.NewLine(startpoint, endpoint, True)
    '            Dim origin As New DB.XYZ(0, 0, 0)
    '            Dim norm As New DB.XYZ(1, 1, 0)
    '            Dim geometryPlane As DB.Plane = App.Application.Create.NewPlane(norm, origin)
    '            Dim plane2 As DB.SketchPlane = App.ActiveUIDocument.Document.Create.NewSketchPlane(geometryPlane)
    '            Dim line2 As DetailLine = TryCast(App.ActiveUIDocument.Document.Create.NewDetailCurve(App.ActiveUIDocument.Document.ActiveView, geometryCurve), DetailLine)

    '        Catch ex As Exception
    '            MsgBox(ex.Message)
    '        End Try
    '    Else
    '        Try
    '            Dim aps As Document = globalcdata.Application.ActiveUIDocument.Document

    '            Dim application As Autodesk.Revit.ApplicationServices.Application = aps.Application




    '            Dim xyz4 As New DB.XYZ
    '            xyz4 = startpoint
    '            Dim xyz3 As New DB.XYZ
    '            xyz3 = endpoint


    '            'Dim origin As New Autodesk.Revit.DB.XYZ(startpoint.X, startpoint.Y, startpoint.Z) '(0, 0, 0)
    '            'Dim normal As New Autodesk.Revit.DB.XYZ(endpoint.X, endpoint.Y, endpoint.Z)
    '            Dim geomLine As Line = application.Create.NewLine(startpoint, endpoint, True)
    '            Dim geomPlane As DB.Plane = application.Create.NewPlane(xyz3, xyz4)
    '            Dim sketch As DB.SketchPlane = aps.Create.NewSketchPlane(geomPlane)
    '            Dim line As ModelLine = TryCast(aps.Create.NewModelCurve(geomLine, sketch), ModelLine)

    '        Catch ex As Exception
    '            MsgBox(ex.Message)
    '        End Try


    '    End If
    'End Sub
    

    Private Function NewSketchPlanePassLine(ByVal line As Line) As DB.SketchPlane
        Dim aps As Document = globalcdata.Application.ActiveUIDocument.Document
        Dim app As Autodesk.Revit.ApplicationServices.Application = aps.Application

        Dim p As DB.XYZ = line.EndPoint(0)
        ''Dim q As DB.XYZ = line.EndPoint(1)

        ''Dim norm As DB.XYZ
        ''If p.X = q.X Then
        ''    norm = DB.XYZ.BasisX
        ''ElseIf p.Y = q.Y Then
        ''    norm = DB.XYZ.BasisY
        ''Else
        ''    norm = DB.XYZ.BasisZ

        ''End If
        Dim norm As DB.XYZ = GetCurveNormal(line)
        Dim plane As DB.Plane = app.Create.NewPlane(norm, p)
        'plane = Autodesk.Revit.Creation.Application.NewPlane(norm, p)

        Return aps.Create.NewSketchPlane(plane)
    End Function

    Private Sub CreateModelLine(ByVal p As DB.XYZ, ByVal q As DB.XYZ)
        Dim aps As Document = globalcdata.Application.ActiveUIDocument.Document
        Dim app As Autodesk.Revit.ApplicationServices.Application = aps.Application
        If p.IsAlmostEqualTo(q) Then

            Throw New ArgumentException("Expected two different points.")
        End If
        Dim line As Line = app.Create.NewLine(p, q, True)
        If line Is Nothing Then
            Throw New Exception("Geometry line creation failed.")
        End If
        aps.Create.NewModelCurve(line, NewSketchPlanePassLine(line))

    End Sub
    Private Function GetCurveNormal(ByVal curve As Curve) As DB.XYZ
        Dim pts As IList(Of DB.XYZ) = curve.Tessellate()
        Dim n As Integer = pts.Count

        Debug.Assert(1 < n, "expected at least two points " & "from curve tessellation")

        Dim p As DB.XYZ = pts(0)
        Dim q As DB.XYZ = pts(n - 1)
        Dim v As DB.XYZ = q - p
        Dim w As DB.XYZ, normal As DB.XYZ = Nothing

        If 2 = n Then
            Debug.Assert(TypeOf curve Is Line, "expected non-line element to have " & "more than two tessellation points")

            ' for non-vertical lines, use Z axis to 
            ' span the plane, otherwise Y axis:

            Dim dxy As Double = Math.Abs(v.X) + Math.Abs(v.Y)

            w = If((dxy > SurfaceTool.BuildingCoder.Util.TolPointOnPlane), DB.XYZ.BasisZ, DB.XYZ.BasisY)


            normal = v.CrossProduct(w).Normalize()
        Else
            Dim i As Integer = 0
            While System.Threading.Interlocked.Increment(i) < n - 1
                w = pts(i) - p
                normal = v.CrossProduct(w)
                If Not normal.IsZeroLength() Then
                    normal = normal.Normalize()
                    Exit While
                End If
            End While

#If DEBUG Then
            If True Then
                Dim normal2 As DB.XYZ
                While System.Threading.Interlocked.Increment(i) < n - 1
                    w = pts(i) - p
                    normal2 = v.CrossProduct(w)
                    Debug.Assert(normal2.IsZeroLength() OrElse SurfaceTool.BuildingCoder.Util.IsZero(normal2.AngleTo(normal)), "expected all points of curve to " & "lie in same plane")
                End While
#End If

            End If

        Return normal
    End Function
End Class
