#region Namespaces
using System.IO;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.Exceptions;
using Autodesk.Revit.UI;
#endregion

namespace TestDemoMode
{
  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    static bool IsDemoMode( Document doc )
    {
      Application app = doc.Application;

      try
      {
        Transaction tx = new Transaction( doc );
        
        tx.Start( "Modify Document" );

        SketchPlane sp 
          = new FilteredElementCollector( doc )
            .OfClass( typeof( SketchPlane ) )
            .FirstElement() as SketchPlane;

        Line line = app.Create.NewLineBound( 
          XYZ.Zero, XYZ.BasisX );

        ModelCurve mc = doc.Create.NewModelCurve(
          line, sp );

        tx.Commit();

        string filename = Path.GetTempFileName();
        File.Delete( filename );

        //SaveAsOptions opt = new SaveAsOptions();
        //opt.OverwriteExistingFile = true;
        //doc.SaveAs( filename, opt );

        doc.SaveAs( filename );
        File.Delete( filename );

        tx.Start( "Unmodify Document" );
        doc.Delete( mc );
        tx.Commit();

        return false;
      }
      catch( InvalidLicenseException ex )
      {
        return true;
      }
    }

    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Document doc = uidoc.Document;
      
      bool rc = IsDemoMode( doc );

      string s = string.Format( 
        "This is {0}a Revit demo version.", 
        rc ? "" : "not " );

      TaskDialog.Show( "Test Demo Mode", s );

      return Result.Succeeded;
    }
  }
}
