#region Namespaces
using System;
using Autodesk.Revit.UI;
#endregion

namespace ToggleButton
{
  class App : IExternalApplication
  {
    static string _path = typeof( App ).Assembly.Location;

    RibbonItem _button;

    /// <summary>
    /// Singleton external application class instance.
    /// </summary>
    internal static App _app = null;

    /// <summary>
    /// Provide access to singleton class instance.
    /// </summary>
    public static App Instance
    {
      get { return _app; }
    }

    public Result OnStartup( 
      UIControlledApplication a )
    {
      _app = this;

      RibbonPanel panel = a.CreateRibbonPanel( 
        "ToggleButton" );

      PushButtonData data = new PushButtonData( 
        "Toggle", "On", _path, 
        "ToggleButton.Command" );

      data.AvailabilityClassName
        = "ToggleButton.Availability";

      _button = panel.AddItem( data );

      return Result.Succeeded;
    }

    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }

    public void Toggle()
    {
      string s = _button.ItemText;

      _button.ItemText = s.Equals( "On" ) ? "Off" : "On";
    }
  }
}
