﻿using System;
using System.Collections.Generic;
using System.Text;

using Autodesk.Revit;
using Autodesk.Revit.Elements;
using Autodesk.Revit.Symbols;
using Autodesk.Revit.MEP;
using Autodesk.Revit.Parameters;
using MEP = Autodesk.Revit.MEP;
using Autodesk.Revit.MEP.Enums;

namespace UK_DB_Schedule
{
  public class Command_CreateShedule : IExternalCommand
  {       
    public IExternalCommand.Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
    {
      Application app = commandData.Application;
      
      CreateDBSchedule cDBS = new CreateDBSchedule();
      cDBS.Run(app);

      return IExternalCommand.Result.Succeeded;
    }
  }

  public class Command_AddCircuitReferences : IExternalCommand
  {
    public IExternalCommand.Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
    {
      Application app = commandData.Application;

      CircuitReferences cr = new CircuitReferences();
      cr.Add_UK_References(app);

      return IExternalCommand.Result.Succeeded;
    }
  }
}
