﻿
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Autodesk.Revit;
using Autodesk.Revit.Creation;

using Autodesk.Revit.UI;
using Autodesk.Revit.DB;
using Autodesk.Revit.Attributes;

namespace Revit.SDK.Samples.UnitConversion.CS
{
    /// <summary>
    /// Demonstrate unit conversions using Revit itself
    /// </summary>
    [Transaction(TransactionMode.Automatic)]
    [Regeneration(RegenerationOption.Manual)]
    public class Command : IExternalCommand
    {
        /// <summary>
        /// The revit application
        /// </summary>
        private static UIApplication _Application;

        /// <summary>
        /// The current document of the application
        /// </summary>
        private static Autodesk.Revit.DB.Document _Document;



        #region IExternalCommand Members
        /// <summary>
        /// Implement this method as an external command for Revit.
        /// </summary>
        /// <param name="commandData">An object that is passed to the external application 
        /// which contains data related to the command, 
        /// such as the application object and active view.</param>
        /// <param name="message">A message that can be set by the external application 
        /// which will be displayed if a failure or cancellation is returned by 
        /// the external command.</param>
        /// <param name="elements">A set of elements to which the external application 
        /// can add elements that are to be highlighted in case of failure or cancellation.</param>
        /// <returns>Return the status of the external command. 
        /// A result of Succeeded means that the API external method functioned as expected. 
        /// Cancelled can be used to signify that the user cancelled the external operation 
        /// at some point. Failure should be returned if the application is unable to proceed with 
        /// the operation.</returns>
        public Result Execute(ExternalCommandData commandData,
                                               ref string message,
                                               ElementSet elements)
        {
            // set our default result to failure.
            Result retRes = Result.Failed;

            _Application = commandData.Application;
            _Document = _Application.ActiveUIDocument.Document;

            if (null == _Document)
            {
                MessageBox.Show("There's no available document. \n");
                return Result.Cancelled;
            }

            if (!_Document.IsFamilyDocument)
            {
                MessageBox.Show("The active document is not a family document. \n");
                return Result.Cancelled;
            }

    
            // Create the dialog form, giving it access to the Revit application.
            frmUnitConversions oForm = new frmUnitConversions(_Application);
            oForm.ShowDialog();

 

            retRes = Result.Cancelled;
            return retRes;
        }

        #endregion

    }
}
