﻿using System;
using System.Windows.Forms;
using Autodesk.Revit.UI;
using Autodesk.Revit.DB;
using Autodesk.Revit.Attributes;

namespace Revit.SDK.Samples.UnitConversion.CS
{
  /// <summary>
  /// Demonstrate unit conversions using Revit itself
  /// </summary>
  [Transaction( TransactionMode.Automatic )]
  public class Command : IExternalCommand
  {
    static AddInId appId = new AddInId( new Guid( "6789c041-cfc2-47f8-a514-497592289d84" ) );

    /// <summary>
    /// The revit application
    /// </summary>
    private static UIApplication _Application;

    /// <summary>
    /// The current document of the application
    /// </summary>
    private static Document _Document;

    public Result Execute( 
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      _Application = commandData.Application;
      _Document = _Application.ActiveUIDocument.Document;

      if( null == _Document )
      {
        MessageBox.Show( "There's no available document." );
        return Result.Cancelled;
      }

      if( !_Document.IsFamilyDocument )
      {
        MessageBox.Show( "The active document is not a family document." );
        return Result.Cancelled;
      }

      // Create the dialog form, giving it access to the Revit application.
      frmUnitConversions oForm = new frmUnitConversions( _Application );
      oForm.ShowDialog();

      // Abort the automatic transaction

      return Result.Failed;
    }

#if ADDITIONAL_SAMPLE_CODE
    public static bool canGetFormatOptions( 
      Document doc, 
      FamilyParameter familyParameter )
    {
      try
      {
        UnitType parameterUnitType 
          = ConvertParameterTypeToUnitType( 
            familyParameter.Definition.ParameterType );

        doc.ProjectUnit.get_FormatOptions( 
          parameterUnitType );

        return true;
      }
      catch
      {
        return false;
      }
    }

    void f()
    {
      if( !canGetFormatOptions( 
        famDoc, familyParameter ) )
      {
        TaskDialog.Show( "Error", 
          "Cannot set parameter value.\nUnit Type " 
          + ConvertParameterTypeToUnitType( 
            familyParameter.Definition.ParameterType ) 
          + " is not supported in Revit " 
          + famDoc.Application.Product.ToString() );
      }
    }
#endif // ADDITIONAL_SAMPLE_CODE
  }
}
