#region Namespaces

using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Windows;
using UIFramework;
using VCButtonsWithVideoToolTip.Properties;
using RibbonItem = Autodesk.Revit.UI.RibbonItem;

#endregion

namespace VCButtonsWithVideoToolTip
{
  class App : IExternalApplication
  {
    private const string tabName = "IVC";
    private const string panelName = "Video tool tip buttons";

    public Result OnStartup( UIControlledApplication a )
    {
      RibbonControl ribbonControl = RevitRibbonControl.RibbonControl;

      var ribbonTab = ribbonControl.FindTab( tabName );

      if( ribbonTab == null )
      {
        a.CreateRibbonTab( tabName );
      }

      var ribbonPanel = a.CreateRibbonPanel( tabName, panelName );

      var button1Data = new PushButtonData( "Button1",
                                           "Button1",
                                           typeof(App).Assembly.Location,
                                           "VCButtonsWithVideoToolTip.Command" );
      button1Data.LargeImage = BitmapSourceConverter.ConvertFromImage( Resources.logoITC );
      button1Data.Image = BitmapSourceConverter.ConvertFromImage( Resources.logoITC_16 );

      var button1 = ribbonPanel.AddItem( button1Data );

      RibbonToolTip toolTip1 = new RibbonToolTip()
      {
        Title = "This is important button1",
        ExpandedContent = @"Here you can see swf video from local file. 
The file path is C:/Program Files
/Autodesk/Revit Structure 2012/Program/videos
/GUID-C9EF04AB-254A-492C-AC5E-12BCDC3D9C54-low.swf",        
        ExpandedVideo = new Uri( "C:/Program Files"
          + "/Autodesk/Revit Structure 2012/Program/videos"
          + "/GUID-C9EF04AB-254A-492C-AC5E-12BCDC3D9C54-low.swf"),
        ExpandedImage = BitmapSourceConverter
          .ConvertFromImage( Resources.logoITC_16 )
      };

      SetRibbonItemToolTip( button1, toolTip1 );

      //--

      var button2Data = new PushButtonData( 
        "Button2",
        "Button2",
        typeof(App).Assembly.Location,
        "VCButtonsWithVideoToolTip.Command" );

      button2Data.Image = BitmapSourceConverter
        .ConvertFromImage( Resources.transmit );

      //--

      //--

      var button3Data = new PushButtonData( 
        "Button3",
        "Button3",
        typeof(App).Assembly.Location,
        "VCButtonsWithVideoToolTip.Command" );

      button3Data.Image = BitmapSourceConverter
        .ConvertFromImage( Resources.weather_sun );

      //--

      var addedItems = ribbonPanel.AddStackedItems( 
        button2Data, button3Data );

      var button2 = addedItems[0];

      RibbonToolTip toolTip2 = new RibbonToolTip()
      {
        Title = "This is a button2",
        ExpandedContent = "Try load gif image from the internet",
        ExpandedVideo = new Uri( "http://static.typepad.com/.shared:v20120605.01-0-gf44e6a1:typepad:en_us/default-userpics/08-50si.gif" ),
      };
      SetRibbonItemToolTip( button2, toolTip2 );

      var button3 = addedItems[1];

      //get swf from embedded resource

      var tempPath = Path.Combine( Path.GetTempPath(), 
        "roadahead_468x60_2.swf" );

      using( Stream stream = Assembly
        .GetExecutingAssembly()
        .GetManifestResourceStream( 
          "VCButtonsWithVideoToolTip.roadahead_468x60_2.swf" ) )
      {
        var buffer = new byte[stream.Length];

        stream.Read( buffer, 0, buffer.Length );

        using( FileStream fs = new FileStream( 
          tempPath, FileMode.Create, FileAccess.Write ) )
        {
          fs.Write( buffer, 0, buffer.Length );
        }
      }

      RibbonToolTip toolTip3 = new RibbonToolTip()
      {
        Title = "This is a button3",
        Content = "This is a content of tool tip",
        ExpandedContent = "swf video from embedded resource",
        ExpandedVideo = new Uri( tempPath ),
        HelpSource = new Uri( "http://thebuildingcoder.typepad.com/blog/2012/06/retrieve-embedded-resource-image.html" ),
        IsHelpEnabled = true,
        IsProgressive = true
      };
      SetRibbonItemToolTip( button3, toolTip3 );

      return Result.Succeeded;
    }

    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }

    void SetRibbonItemToolTip( RibbonItem item, RibbonToolTip toolTip )
    {
      IUIRevitItemConverter itemConverter =
          new InternalMethodUIRevitItemConverter();

      var ribbonItem = itemConverter.GetRibbonItem( item );
      if( ribbonItem == null )
        return;
      ribbonItem.ToolTip = toolTip;
    }
  }
}
