#region Namespaces
using System;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Events;
using System.Diagnostics;
#endregion

namespace ViewActivatedOnDocChange
{
  class App : IExternalApplication
  {
    static string ViewDescription( View v )
    {
      return string.Format( 
        "view '{0}' in document '{1}'",
        v.Name, v.Document.Title );
    }

    void OnViewActivated( 
      object sender, 
      ViewActivatedEventArgs e )
    {
      View vPrevious = e.PreviousActiveView;
      View vCurrent = e.CurrentActiveView;

      string s = ( null == vPrevious )
        ? "no view at all"
        : "previous " + ViewDescription( vPrevious );

      Debug.Print( string.Format( 
        "Switching from {0} to new {1}.",
        s, ViewDescription( vCurrent ) ) );
    }

    public Result OnStartup( UIControlledApplication a )
    {
      a.ViewActivated
        += new EventHandler<ViewActivatedEventArgs>(
          OnViewActivated );

      return Result.Succeeded;
    }

    public Result OnShutdown( UIControlledApplication a )
    {
      return Result.Succeeded;
    }
  }
}
