using System;
using System.Threading;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using IVC.NotifyBox.Controls;
using IVC.NotifyBox.ViewModel.Enums;

namespace YetAnotherBaloons
{
    [Transaction(TransactionMode.Manual)]
    public class StartBaloonFromAnotherThreadCommand : IExternalCommand
    {
        public Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {
            System.Threading.Tasks.Task.Factory.StartNew(() =>
                {
                    Thread.Sleep(TimeSpan.FromSeconds(3));
                    NotifyBox.Show("Warning", "This message is from another thread!", NotificationIcon.Warning, NotificationDuration.Medium);
                });
            return Result.Succeeded;
        }
    }
}