﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Autodesk.Revit.Elements;

namespace BuildingCoder.MyObjects
{
    class Segment
    {
        Autodesk.Revit.Geometry.XYZ _stPt;

        public Autodesk.Revit.Geometry.XYZ StartPoint
        {
            get { return _stPt; }
        }
        Autodesk.Revit.Geometry.XYZ _enPt;

        public Autodesk.Revit.Geometry.XYZ EndPoint
        {
            get { return _enPt; }
        }

        Space _sp;

        public Space Space
        {
            get { return _sp; }
            set { _sp = value; }
        }


        public Segment(Autodesk.Revit.Geometry.XYZ startPoint, Autodesk.Revit.Geometry.XYZ endPoint, Space space)
        {
            _stPt = startPoint;
            _enPt = endPoint;
            _sp = space;
        }

        public double Slope
        {
            get
            {
                double deltaX = _stPt.X - _enPt.X;
                double deltaY = _stPt.Y - _enPt.Y;
                if (deltaX != 0)
                {
                    return deltaY / deltaX;
                }
                return 0;
            }
        }

        public bool IsHorizontal
        {
            get
            {
                return _stPt.Y == _enPt.Y;
            }
        }

        public bool IsVertical
        {
            get
            {
                return _stPt.X == _enPt.X;
            }
        }

        public new string ToString()
        {
            return string.Format("({0},{1},{2}) ({3},{4},{5})", _stPt.X, _stPt.Y, _stPt.Z, _enPt.X, _enPt.Y, _enPt.Z);
        }

        public Autodesk.Revit.Geometry.XYZ MidPoint
        {
            get
            {
                double avgX = (_stPt.X + _enPt.X) / 2.0;
                double avgY = (_stPt.Y + _enPt.Y) / 2.0;
                double avgZ = (_stPt.Z + _enPt.Z) / 2.0;
                return new Autodesk.Revit.Geometry.XYZ(avgX, avgY, avgZ);
            }
        }

        public Autodesk.Revit.Geometry.XYZ DirectionTo(Segment otherSegment)
        {
            double deltaX = otherSegment.MidPoint.X - this.MidPoint.X;
            double deltaY = otherSegment.MidPoint.Y - this.MidPoint.Y;
            double deltaZ = otherSegment.MidPoint.Z - this.MidPoint.Z;
            Autodesk.Revit.Geometry.XYZ retVal = new Autodesk.Revit.Geometry.XYZ(deltaX, deltaY, deltaZ);
            if (deltaX + deltaY + deltaZ != 0)
            {
                return retVal.Normalized;
            }
            return retVal;
                
        }


        public double Distance(Segment otherSegment)
        {
            return this.MidPoint.Distance(otherSegment.MidPoint);
        }

        public bool Parallel(Segment otherSegment)
        {
            if (this.IsVertical && otherSegment.IsVertical)
            {
                return true;
            }
            if (this.IsHorizontal && otherSegment.IsHorizontal)
            {
                return true;
            }
            if (this.Slope == otherSegment.Slope)
            {
                return true;
            }
            return false;

        }
        

    }
}
