﻿#region Header
//
// CmdMirror.cs - mirror some elements.
//
// Copyright (C) 2009-2010 by Jeremy Tammik,
// Autodesk Inc. All rights reserved.
//
#endregion // Header

#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion // Namespaces

namespace BuildingCoder
{
  [Transaction( TransactionMode.Automatic )]
  [Regeneration( RegenerationOption.Manual )]
  class CmdMirror : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      ElementSet els = uidoc.Selection.Elements;

      Line line = app.Create.NewLine(
        XYZ.Zero, XYZ.BasisX, true );

      doc.Mirror( els, line );

      return Result.Succeeded;
    }
  }

  [Transaction( TransactionMode.Automatic )]
  [Regeneration( RegenerationOption.Manual )]
  class CmdMirrorListAdded : IExternalCommand
  {
    FilteredElementCollector GetElements( Document doc )
    {
      FilteredElementCollector collector
        = new FilteredElementCollector( doc );
      collector.WhereElementIsNotElementType();
      collector.WhereElementIsViewIndependent();
      return collector;
    }

    int GetElementCount( Document doc )
    {
      return GetElements( doc ).ToElements().Count;
    }

    List<Element> GetElementsAfter( int n, Document doc )
    {
      List<Element> a = new List<Element>();
      FilteredElementCollector c = GetElements( doc );
      int i = 0;

      foreach( Element e in c )
      {
        ++i;

        if( n < i )
        {
          a.Add( e );
        }
      }
      return a;
    }

    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      Debug.Assert( false, "this has not been tested yet in Revit 2011!" );

      UIApplication uiapp = commandData.Application;
      UIDocument uidoc = uiapp.ActiveUIDocument;
      Application app = uiapp.Application;
      Document doc = uidoc.Document;

      ElementSet els = uidoc.Selection.Elements;

      Line line = app.Create.NewLine(
        XYZ.Zero, XYZ.BasisX, true );

      int n = GetElementCount( doc );

      doc.Mirror( els, line );

      List<Element> a = GetElementsAfter( n, doc );

      string s = "The following elements were mirrored:\r\n";

      foreach( Element e in a )
      {
        s += string.Format( "\r\n  {0}",
          Util.ElementDescription( e ) );
      }
      Util.InfoMsg( s );

      return Result.Succeeded;
    }
  }
}
