#region Header
//
// CmdBoundingBox.cs - eplore element bounding box
//
// Copyright (C) 2008-2010 by Jeremy Tammik,
// Autodesk Inc. All rights reserved.
//
#endregion // Header

#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion // Namespaces

namespace BuildingCoder
{
  [Transaction( TransactionMode.Automatic )]
  [Regeneration( RegenerationOption.Manual )]
  class CmdBoundingBox : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      UIApplication app = commandData.Application;
      UIDocument uidoc = app.ActiveUIDocument;
      Document doc = uidoc.Document;

      Element e = Util.SelectSingleElement(
        uidoc, "an element" );

      if( null == e )
      {
        message = "No element selected";
        return Result.Failed;
      }

      //
      // trying to call this property returns the
      // compile time error: Property, indexer, or
      // event 'BoundingBox' is not supported by
      // the language; try directly calling
      // accessor method 'get_BoundingBox( View )'
      //
      //BoundingBoxXYZ b = e.BoundingBox[null];

      BoundingBoxXYZ b = e.get_BoundingBox( null );

      Debug.Assert( b.Transform.IsIdentity,
        "expected identity Element bounding box transform" );

      Debug.Print(
        "Element bounding box of {0}"
        + " extends from {1} to {2}.",
        Util.ElementDescription( e ),
        Util.PointString( b.Min ),
        Util.PointString( b.Max ) );

      return Result.Succeeded;
    }
  }
}
