"""Calculates total volume of all selected elements."""

import clr
clr.AddReference('RevitAPI')
import Autodesk
clr.AddReference('RevitAPIUI')
from Autodesk.Revit.UI import TaskDialog
clr.AddReference('RevitServices')

from RevitServices.Persistence import DocumentManager
from Autodesk.Revit.DB import FilteredElementCollector, BuiltInCategory, BuiltInParameter, UnitType, UnitUtils, DisplayUnitType

# Tansaction usage
#t = DB.Transaction(doc, "StartDateAndTime temporary set")
#t.Start()
#t.Commit()

# Global var __revit__ holds active application instance object for referrencing Document and UIdocument objects
doc = __revit__.ActiveUIDocument.Document
uidoc = __revit__.ActiveUIDocument

selection = [doc.GetElement(elId) for elId in uidoc.Selection.GetElementIds()]

total_volume = 0.0
values = []
unitTypes = []
for el in selection:
	vol_param = el.Parameter[BuiltInParameter.HOST_VOLUME_COMPUTED]
	if vol_param:
		unitTypes.append(vol_param.DisplayUnitType)
		values.append((UnitUtils.ConvertFromInternalUnits(vol_param.AsDouble(), DisplayUnitType.DUT_CUBIC_METERS), el.Id))
		total_volume = total_volume + vol_param.AsDouble()

# now that results are collected, print the total
#docUnits = doc.GetUnits()
#displayUnits = docUnits.GetFormatOptions(UnitType.UT_Volume).DisplayUnits
unitConversion = UnitUtils.ConvertFromInternalUnits(total_volume, DisplayUnitType.DUT_CUBIC_METERS)
#print("docUnits {0}".format(docUnits))
#print("unitConversion {0}".format(unitConversion))
expandedContentStr = ""
mainInstructionStr = ""
for i, v in enumerate(values):
	#print("{pos} - {volume} - {id}".format(pos = i, volume = v[0], id = v[1]))
	expandedContentStr += "{pos} - {volume} - {id}\n".format(pos = i, volume = v[0], id = v[1])
#print("Number of all selected elements: {}".format(len(selection)))
mainInstructionStr += "Number of all selected elements: {}\n".format(len(selection))
#print("Number of elements with volume parameter: {}".format(len(values)))
mainInstructionStr += "Number of elements with volume parameter: {}\n".format(len(values))
#print("Total Volume is: {} m3".format(unitConversion))
mainInstructionStr += "Total Volume is: {} m3".format(unitConversion)

myDialog = TaskDialog("Volume Result:")
myDialog.MainInstruction = "{0}".format(mainInstructionStr)
myDialog.ExpandedContent = "{0}".format(expandedContentStr)
myDialog.Show()
#print(unitTypes)
