#region Namespaces
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using IronPython.Hosting;

#endregion

namespace VlastniKarta
{
    [Transaction(TransactionMode.Manual)]
    public class totalSelectedVolumeCommand : IExternalCommand
    {
        public Result Execute(
          ExternalCommandData commandData,
          ref string message,
          ElementSet elements)
        {
            UIApplication uiapp = commandData.Application;
            UIDocument uidoc = uiapp.ActiveUIDocument;
            Application app = uiapp.Application;
            Document doc = uidoc.Document;
            var py = Python.CreateEngine();
            try
            {
                py.ExecuteFile("totalSelectedVolume.py");
            }
            catch (Exception ex)
            {
                TaskDialog.Show("IronPython Error", "Couldn't execute IronPython script totalSelectedVolume.py: " + ex.Message);
            }

            return Result.Succeeded;
        }
    }
}
